/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.entlive.proccessor;

import com.duowan.mobile.entlive.annotation.ModuleConfigDiffSupplement;
import com.duowan.mobile.entlive.annotation.ModuleConfigs;
import com.duowan.mobile.entlive.utils.ELModuleConfigUtilForBuild;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class ELModuleConfigsDiffSupplementProcessorUtil {
    private static final String CLASS_NAME = "DiffSupplementsFactory";
    private static final String METHOD_NAME = "getDiffSupplement";
    private static final String ARGUMENT_COMPONENT_NAME = "componentName";
    private static final String ARGUMENT_DIFF_NAME = "diffName";
    private static final String FIELD_APPEND = "append";
    private static final String FIELD_HIDE = "hide";

    public static void handleELModuleConfigsDiffSupplement(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, Messager messager) {
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(ModuleConfigs.class);
        ClassName linkedListClassName = ClassName.get((String)"java.util", (String)"LinkedList", (String[])new String[0]);
        ClassName supplementClassName = ClassName.get((String)"com.yy.live.basic.module.management.differentsupplement", (String)"DiffSupplement", (String[])new String[0]);
        boolean isFirstControlFlow = true;
        for (Element element : set) {
            if (element.getKind() == ElementKind.CLASS) {
                CodeBlock.Builder builder = CodeBlock.builder();
                builder.addStatement("$T<String> append = new $T<>()", new Object[]{linkedListClassName, linkedListClassName});
                builder.addStatement("$T<String> hide = new $T<>()", new Object[]{linkedListClassName, linkedListClassName});
                ModuleConfigs moduleWrapper = element.getAnnotation(ModuleConfigs.class);
                for (ModuleConfigDiffSupplement supplement : moduleWrapper.diffSupplement()) {
                    TypeElement classTypeElement;
                    String diffName = supplement.diffName();
                    String controlFlow = "if (componentName.equals($S)\n&& diffName.equals($S))";
                    if (isFirstControlFlow) {
                        builder.beginControlFlow(controlFlow, new Object[]{ELModuleConfigUtilForBuild.convertToModuleGroupKey((ProcessingEnvironment)processingEnv, (ModuleConfigs)moduleWrapper), diffName});
                        isFirstControlFlow = false;
                    } else {
                        builder.beginControlFlow("else " + controlFlow, new Object[]{ELModuleConfigUtilForBuild.convertToModuleGroupKey((ProcessingEnvironment)processingEnv, (ModuleConfigs)moduleWrapper), diffName});
                    }
                    try {
                        supplement.appendMembers();
                    }
                    catch (MirroredTypesException e) {
                        for (TypeMirror typeMirror : e.getTypeMirrors()) {
                            classTypeElement = ELModuleConfigsDiffSupplementProcessorUtil.asTypeElement(processingEnv, typeMirror);
                            builder.addStatement("append.add($S)", new Object[]{classTypeElement.getQualifiedName()});
                        }
                    }
                    try {
                        supplement.removeMembers();
                    }
                    catch (MirroredTypesException e) {
                        for (TypeMirror typeMirror : e.getTypeMirrors()) {
                            classTypeElement = ELModuleConfigsDiffSupplementProcessorUtil.asTypeElement(processingEnv, typeMirror);
                            builder.addStatement("hide.add($S)", new Object[]{classTypeElement.getQualifiedName()});
                        }
                        builder.addStatement("return new DiffSupplement(append, hide)", new Object[0]);
                    }
                    builder.endControlFlow();
                }
                MethodSpec createDiffSupplementMethod = MethodSpec.methodBuilder((String)METHOD_NAME).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).returns((TypeName)supplementClassName).addParameter(String.class, ARGUMENT_COMPONENT_NAME, new Modifier[0]).addParameter(String.class, ARGUMENT_DIFF_NAME, new Modifier[0]).addCode(builder.build()).addStatement("return null", new Object[0]).build();
                String detailName = ELModuleConfigUtilForBuild.convertToModuleGroupKey((ProcessingEnvironment)processingEnv, (ModuleConfigs)moduleWrapper);
                String classNamePrefix = ClassName.bestGuess((String)detailName).simpleName();
                TypeSpec manager = TypeSpec.classBuilder((String)(classNamePrefix + "$$" + CLASS_NAME)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(createDiffSupplementMethod).addAnnotation(ClassName.get((String)"com.yy.mobile.util", (String)"DontProguardClass", (String[])new String[0])).build();
                JavaFile javaFile = JavaFile.builder((String)"com.yy.live.basic", (TypeSpec)manager).build();
                try {
                    javaFile.writeTo(processingEnv.getFiler());
                }
                catch (IOException e) {
                    messager.printMessage(Diagnostic.Kind.WARNING, "printing ,initELModuleConfigs error" + e.getMessage());
                }
                continue;
            }
            messager.printMessage(Diagnostic.Kind.NOTE, "only support class");
        }
    }

    private static TypeElement asTypeElement(ProcessingEnvironment processingEnv, TypeMirror typeMirror) {
        Types typeutils = processingEnv.getTypeUtils();
        return (TypeElement)typeutils.asElement(typeMirror);
    }
}

