/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.entlive.proccessor;

import com.duowan.mobile.entlive.annotation.BindConfig;
import com.duowan.mobile.entlive.annotation.ComponentWrapper;
import com.duowan.mobile.entlive.annotation.DefaultInitAttr;
import com.duowan.mobile.entlive.annotation.InitAttrConfig;
import com.duowan.mobile.entlive.annotation.InitAttrConfigs;
import com.duowan.mobile.entlive.annotation.InitWithBundle;
import com.duowan.mobile.entlive.annotation.ModuleConfigDiffSupplement;
import com.duowan.mobile.entlive.annotation.ModuleConfigs;
import com.duowan.mobile.entlive.annotation.ModuleWrapper;
import com.duowan.mobile.entlive.domain.FreeContainer;
import com.duowan.mobile.entlive.proccessor.ComponentInfo;
import com.duowan.mobile.entlive.proccessor.ComponentUnit;
import com.duowan.mobile.entlive.proccessor.ELModuleConfigsDiffSupplementProcessorUtil;
import com.duowan.mobile.entlive.proccessor.ELModulesProcessorUtil;
import com.duowan.mobile.entlive.proccessor.ModuleProxyInfo;
import com.duowan.mobile.entlive.proccessor.ProcessorUtil;
import com.duowan.mobile.entlive.proccessor.RFileResolver;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class ComponentProcessor
extends AbstractProcessor {
    private Filer mFiler;
    private Elements mElementUtils;
    private Messager mMessager;
    private ClassName mWrapperParent;
    private TypeName mIComponentTypeName;
    private HashMap<TypeMirror, ComponentUnit> mComponentsMap = new HashMap();
    private HashMap<TypeElement, List<? extends TypeMirror>> mConfigToComponentMap = new HashMap();
    private HashMap<TypeElement, TypeElement> mConfigExtendMap = new HashMap();
    private HashMap<TypeElement, List<ComponentArgument>> mConfigMap = new HashMap();
    private HashMap<String, ModuleProxyInfo> modulesProxyMap = new HashMap();
    private HashMap<String, ComponentInfo> componentMap = new HashMap();
    private static final String PACKAGE = "com.duowan.mobile.entlive";
    private String packageName;
    private String moduleName;
    private Map<String, String> aptOption = Collections.emptyMap();
    private HashMap<TypeElement, TypeMirror> mContainerToConfigMap = new HashMap();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.mFiler = processingEnv.getFiler();
        this.mElementUtils = processingEnv.getElementUtils();
        this.mMessager = processingEnv.getMessager();
        this.aptOption = processingEnv.getOptions();
        if (this.aptOption != null && !this.aptOption.isEmpty()) {
            this.moduleName = this.aptOption.get("moduleName");
            this.packageName = this.aptOption.get("package");
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(DefaultInitAttr.class.getCanonicalName());
        types.add(InitWithBundle.class.getCanonicalName());
        types.add(InitAttrConfigs.class.getCanonicalName());
        types.add(ModuleWrapper.class.getCanonicalName());
        types.add(ModuleConfigs.class.getCanonicalName());
        types.add(ModuleConfigDiffSupplement.class.getCanonicalName());
        types.add(BindConfig.class.getCanonicalName());
        types.add(ComponentWrapper.class.getCanonicalName());
        return types;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.setupContainerToConfigMap(roundEnv);
            this.setupComponentsMap(roundEnv);
            this.getInitBundleMethod(roundEnv);
            this.initComponentsMap(roundEnv);
            this.initModulesMap(roundEnv);
            this.initComponentMap(roundEnv);
            this.initELModuleConfigs(roundEnv);
            this.mWrapperParent = this.getAbstractWrapper();
            this.mIComponentTypeName = this.getIComponentTypeName();
            this.createWrapperChildren();
            this.createFactoryImpl();
            this.createModulesConstantName();
            this.createComponentConstantName();
            this.createWrapperModules();
        }
        catch (Throwable e) {
            this.mMessager.printMessage(Diagnostic.Kind.ERROR, "error = " + e);
        }
        return true;
    }

    private void createModulesConstantName() {
        try {
            ModuleProxyInfo.generateModulesConstantName(this.processingEnv.getFiler(), this.modulesProxyMap);
        }
        catch (IOException e) {
            System.out.println("createModulesConstantName " + e);
        }
    }

    private void createComponentConstantName() {
        try {
            ComponentInfo.generateComponentConstantName(this.processingEnv.getFiler(), this.componentMap);
        }
        catch (IOException e) {
            System.out.println("createModulesConstantName " + e);
        }
    }

    private void initComponentMap(RoundEnvironment roundEnv) {
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(ComponentWrapper.class);
        for (Element element : set) {
            if (element.getKind() == ElementKind.CLASS && !ProcessorUtil.isAbstract(element)) {
                String clzName = element.getSimpleName().toString();
                ComponentInfo componentInfo = null;
                componentInfo = this.componentMap.get(clzName) != null ? this.componentMap.get(clzName) : new ComponentInfo(this.mElementUtils, (TypeElement)element);
                componentInfo.setTypeElement((TypeElement)element);
                componentInfo.setClsName(clzName);
                this.componentMap.put(clzName, componentInfo);
                continue;
            }
            this.mMessager.printMessage(Diagnostic.Kind.NOTE, "only support class");
        }
    }

    private void createWrapperModules() {
        for (String key : this.modulesProxyMap.keySet()) {
            ModuleProxyInfo proxyInfo = this.modulesProxyMap.get(key);
            try {
                proxyInfo.generateModuleProxyClass(this.processingEnv.getFiler());
            }
            catch (IOException e) {
                System.out.println("generateModuleProxyClass " + e);
            }
        }
        try {
            ModuleProxyInfo.generateModuleProxyContainer(this.processingEnv.getFiler(), this.modulesProxyMap);
        }
        catch (IOException e) {
            System.out.println("generateModuleProxyContainer " + e);
        }
    }

    private void initELModuleConfigs(RoundEnvironment roundEnv) {
        ELModulesProcessorUtil.handleELModules(this.processingEnv, roundEnv, this.mMessager);
        ELModuleConfigsDiffSupplementProcessorUtil.handleELModuleConfigsDiffSupplement(this.processingEnv, roundEnv, this.mMessager);
    }

    private void initModulesMap(RoundEnvironment roundEnv) {
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(ModuleWrapper.class);
        for (Element element : set) {
            if (element.getKind() == ElementKind.CLASS && !ProcessorUtil.isAbstract(element)) {
                String clzName = element.getSimpleName().toString();
                ModuleProxyInfo proxyInfo = null;
                proxyInfo = this.modulesProxyMap.get(clzName) != null ? this.modulesProxyMap.get(clzName) : new ModuleProxyInfo(this.mElementUtils, (TypeElement)element);
                proxyInfo.setTypeElement((TypeElement)element);
                proxyInfo.setClsName(clzName);
                this.modulesProxyMap.put(clzName, proxyInfo);
                continue;
            }
            this.mMessager.printMessage(Diagnostic.Kind.NOTE, "only support class");
        }
    }

    private TypeName getIComponentTypeName() {
        ClassName targetClassName = ClassName.get((String)"com.yy.mobile.ui.basicchanneltemplate.component", (String)"IComponent", (String[])new String[0]);
        return targetClassName;
    }

    private void initComponentsMap(RoundEnvironment roundEnv) {
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(DefaultInitAttr.class);
        for (Element element : set) {
            if (element.getKind() == ElementKind.CLASS && !ProcessorUtil.isAbstract(element)) {
                String clzName = element.getSimpleName().toString();
                clzName = clzName.split("<")[0];
                ComponentUnit unit = null;
                unit = this.mComponentsMap.get(element.asType()) != null ? this.mComponentsMap.get(element.asType()) : new ComponentUnit();
                unit.setDefaultInitAttr(element.getAnnotation(DefaultInitAttr.class));
                unit.setClassName(clzName);
                this.mComponentsMap.put(element.asType(), unit);
                continue;
            }
            System.out.println("only support class");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setupComponentsMap(RoundEnvironment roundEnv) {
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(InitAttrConfigs.class);
        for (Element element : set) {
            void var4_4;
            ArrayList<TypeMirror> list;
            InitAttrConfig[] value;
            block6: {
                InitAttrConfigs configs;
                if (element.getKind() != ElementKind.INTERFACE && element.getKind() != ElementKind.CLASS || (configs = element.getAnnotation(InitAttrConfigs.class)) == null) continue;
                value = configs.value();
                list = new ArrayList<TypeMirror>();
                try {
                    configs.parentConfig();
                }
                catch (MirroredTypeException e) {
                    TypeMirror typeMirror = e.getTypeMirror();
                    if (ClassName.get((TypeMirror)typeMirror).equals((Object)ClassName.get(Void.class))) break block6;
                    TypeElement parentType = this.asTypeElement(typeMirror);
                    this.mConfigExtendMap.put((TypeElement)element, parentType);
                    TypeElement typeElement = this.asTypeElement(typeMirror);
                }
            }
            for (int i = 0; i < value.length; ++i) {
                try {
                    value[i].component();
                    continue;
                }
                catch (MirroredTypeException e) {
                    String clzName = var4_4.getSimpleName().toString();
                    TypeMirror typeMirror = e.getTypeMirror();
                    list.add(typeMirror);
                    ComponentUnit unit = null;
                    unit = this.mComponentsMap.get(typeMirror) != null ? this.mComponentsMap.get(typeMirror) : new ComponentUnit();
                    unit.setClassName(clzName);
                    unit.addConfigs(value[i], (Element)var4_4);
                    this.mComponentsMap.put(typeMirror, unit);
                }
            }
            this.mConfigToComponentMap.put((TypeElement)var4_4, list);
        }
    }

    private void setupContainerToConfigMap(RoundEnvironment roundEnv) {
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(BindConfig.class);
        for (Element element : set) {
            if (element.getKind() != ElementKind.CLASS) continue;
            BindConfig bindConfig = element.getAnnotation(BindConfig.class);
            try {
                bindConfig.value();
            }
            catch (MirroredTypeException e) {
                TypeMirror typeMirror = e.getTypeMirror();
                this.mContainerToConfigMap.put((TypeElement)element, typeMirror);
            }
        }
    }

    private void getInitBundleMethod(RoundEnvironment roundEnv) {
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(InitWithBundle.class);
        for (Element element : set) {
            if (element.getKind() == ElementKind.METHOD) {
                List<ComponentArgument> methodList;
                TypeElement parentConfig;
                ExecutableElement method = (ExecutableElement)element;
                Set<Modifier> modifiers = method.getModifiers();
                if (!modifiers.contains((Object)Modifier.PUBLIC)) {
                    throw new RuntimeException("the method must be public");
                }
                if (!method.getReturnType().toString().equals("android.os.Bundle")) {
                    throw new RuntimeException("the method must be return type android.os.Bundle");
                }
                TypeElement configClz = (TypeElement)element.getEnclosingElement();
                if (!this.mConfigExtendMap.isEmpty() && (parentConfig = this.mConfigExtendMap.get(configClz)) != null) {
                    configClz = parentConfig;
                }
                if ((methodList = this.mConfigMap.get(configClz)) == null) {
                    methodList = new ArrayList<ComponentArgument>();
                    this.mConfigMap.put(configClz, methodList);
                }
                this.mMessager.printMessage(Diagnostic.Kind.NOTE, "method name:" + method.getSimpleName());
                InitWithBundle components = element.getAnnotation(InitWithBundle.class);
                try {
                    components.value();
                }
                catch (MirroredTypeException e) {
                    TypeMirror mirror = e.getTypeMirror();
                    methodList.add(new ComponentArgument(mirror, method));
                }
                continue;
            }
            System.out.println("not support abstract class");
        }
    }

    private void createFactoryImpl() {
        AnnotatedConstruct typeElement;
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        for (Map.Entry<TypeMirror, ComponentUnit> entry : this.mComponentsMap.entrySet()) {
            TypeMirror typeMirror = entry.getKey();
            String className = entry.getValue().getWrapperClassName();
            ClassName implClass = ClassName.get((String)PACKAGE, (String)className, (String[])new String[0]);
            codeBlock.addStatement("mComponentWrappers.put($T.class, $T.class)", new Object[]{typeMirror, implClass});
        }
        int index = 1;
        for (Map.Entry<TypeElement, List<? extends TypeMirror>> entry : this.mConfigToComponentMap.entrySet()) {
            typeElement = entry.getKey();
            List<? extends TypeMirror> list = entry.getValue();
            ParameterizedTypeName fanxing = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)this.mIComponentTypeName)});
            ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)ClassName.get(ArrayList.class), (TypeName[])new TypeName[]{fanxing});
            codeBlock.addStatement("$T list$L = new $T<>()", new Object[]{name, index, ArrayList.class});
            for (TypeMirror mirror : list) {
                codeBlock.addStatement("list$L.add($T.class)", new Object[]{index, mirror});
            }
            codeBlock.addStatement("mConfigToComponentMap.put($T.class, list$L)", new Object[]{typeElement, index});
            ++index;
        }
        for (Map.Entry<TypeElement, TypeMirror> entry : this.mContainerToConfigMap.entrySet()) {
            typeElement = entry.getValue();
            TypeElement id = entry.getKey();
            codeBlock.addStatement("mContainerToConfigMap.put($T.class, $T.class)", new Object[]{id, typeElement});
        }
        for (Map.Entry<TypeElement, TypeElement> entry : this.mConfigExtendMap.entrySet()) {
            TypeElement child = entry.getKey();
            TypeElement parent = entry.getValue();
            codeBlock.addStatement("mConfigExtendMap.put($T.class, $T.class)", new Object[]{parent, child});
        }
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"initClzMap").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).returns(TypeName.VOID).addCode(codeBlock.build()).build();
        ClassName className = ClassName.get((String)"com.duowan.mobile.basemedia.watchlive.template.generate", (String)"ComponentsFactory", (String[])new String[0]);
        TypeSpec typeSpec = TypeSpec.classBuilder((String)("ComponentsFactoryIpml_" + this.moduleName)).superclass((TypeName)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(methodSpec).build();
        JavaFile javaFile = JavaFile.builder((String)PACKAGE, (TypeSpec)typeSpec).build();
        try {
            javaFile.writeTo(this.processingEnv.getFiler());
        }
        catch (Exception e) {
            System.out.println("createFactoryImpl " + e);
        }
    }

    private void createWrapperChildren() throws Throwable {
        if (this.mWrapperParent == null) {
            return;
        }
        RFileResolver rFileResolver = RFileResolver.create(this.aptOption);
        ClassName r = ClassName.get((String)rFileResolver.getRPackage(), (String)"R", (String[])new String[0]);
        ClassName initConfigClass = ClassName.get((String)"com.duowan.mobile.basemedia.watchlive.template.generate", (String)"InitConfig", (String[])new String[0]);
        ClassName containerConfigClass = ClassName.get((String)"com.duowan.mobile.entlive.domain", (String)"ContainerConfig", (String[])new String[0]);
        ClassName bundle = ClassName.get((String)"android.os", (String)"Bundle", (String[])new String[0]);
        for (Map.Entry<TypeMirror, ComponentUnit> entry : this.mComponentsMap.entrySet()) {
            ComponentUnit unit = entry.getValue();
            TypeMirror typeElement = entry.getKey();
            List<InitAttrConfig> configs = unit.getInitConfigs();
            CodeBlock.Builder builder = CodeBlock.builder();
            if (configs != null) {
                builder.addStatement("mConfigs = new $T()", new Object[]{HashMap.class});
                int index = 0;
                for (InitAttrConfig config : configs) {
                    int resId = config.resourceId();
                    if (r != null && rFileResolver != null) {
                        String fieldName = rFileResolver.getFieldName("id", resId);
                        if (fieldName == null) {
                            builder.addStatement("mConfigs.put($T.class, new $T($L, $L))", new Object[]{unit.getBussinessId(index) == null ? FreeContainer.class : unit.getBussinessId(index), initConfigClass, config.initLevel().getValue(), resId});
                        } else {
                            builder.addStatement("mConfigs.put($T.class, new $T($L, $T.id." + fieldName + "))", new Object[]{unit.getBussinessId(index) == null ? FreeContainer.class : unit.getBussinessId(index), initConfigClass, config.initLevel().getValue(), r});
                        }
                    } else {
                        builder.addStatement("mConfigs.put($T.class, new $T($L, $L))", new Object[]{unit.getBussinessId(index) == null ? FreeContainer.class : unit.getBussinessId(index), initConfigClass, config.initLevel().getValue(), resId});
                    }
                    ++index;
                }
            }
            CodeBlock.Builder oldArgumentBlock = CodeBlock.builder();
            CodeBlock.Builder argumentBlock = CodeBlock.builder();
            argumentBlock.addStatement("$T argument = new $T()", new Object[]{bundle, bundle});
            if (configs != null) {
                int index = 0;
                for (InitAttrConfig config : configs) {
                    Element parentConfig = unit.getBussinessId(index);
                    List<ComponentArgument> list = this.mConfigMap.get(parentConfig);
                    if (list != null) {
                        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
                        for (ComponentArgument arg : list) {
                            if (arg.componentCls != typeElement) continue;
                            methods.add(arg.getArgumentMethod);
                        }
                        for (ExecutableElement method : methods) {
                            if (method == null) continue;
                            this.mMessager.printMessage(Diagnostic.Kind.WARNING, "get method:" + method);
                            Element callClz = parentConfig;
                            for (Map.Entry<TypeElement, TypeElement> elementEntry : this.mConfigExtendMap.entrySet()) {
                                if (elementEntry.getValue() != parentConfig) continue;
                                callClz = elementEntry.getKey();
                            }
                            if (method.getModifiers().contains((Object)Modifier.STATIC)) {
                                oldArgumentBlock.beginControlFlow("if (config == $T.class)", new Object[]{parentConfig});
                                oldArgumentBlock.addStatement("return $T.$N()", new Object[]{callClz, method.getSimpleName()});
                                oldArgumentBlock.endControlFlow();
                                argumentBlock.beginControlFlow("if (config instanceof $T)", new Object[]{parentConfig}).addStatement("$T staticArgument = $T.$N()", new Object[]{bundle, callClz, method.getSimpleName()}).beginControlFlow("if (staticArgument != null)", new Object[0]).addStatement("argument.putAll(staticArgument)", new Object[0]).endControlFlow().endControlFlow();
                                continue;
                            }
                            argumentBlock.beginControlFlow("if (config instanceof $T)", new Object[]{callClz}).addStatement("$T nonStaticArgument = (($T)config).$N()", new Object[]{bundle, callClz, method.getSimpleName()}).beginControlFlow("if (nonStaticArgument != null)", new Object[0]).addStatement("argument.putAll(nonStaticArgument)", new Object[0]).endControlFlow().endControlFlow();
                        }
                    }
                    ++index;
                }
            }
            argumentBlock.addStatement("return argument", new Object[0]);
            MethodSpec superMethod = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($L)", new Object[]{unit.getDefaultInitLevel()}).addCode(builder.build()).build();
            MethodSpec createInstanceMethod = MethodSpec.methodBuilder((String)"creatInstance").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).addParameter((TypeName)bundle, "bundle", new Modifier[0]).returns(TypeName.get((TypeMirror)typeElement)).addStatement("$T ret = new $T()", new Object[]{typeElement, typeElement}).addStatement("ret.setArguments(bundle)", new Object[0]).addStatement("return ret", new Object[]{typeElement}).build();
            MethodSpec getConfigBundleMethod = MethodSpec.methodBuilder((String)"getConfigBundle").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addAnnotation(Deprecated.class).addJavadoc("@deprecated Use getConfigBundle(ContainerConfig config) instead.", new Object[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)containerConfigClass)}), "config", new Modifier[0]).returns((TypeName)bundle).addCode(oldArgumentBlock.build()).addStatement("return null", new Object[0]).build();
            MethodSpec getConfigBundleMethod2 = MethodSpec.methodBuilder((String)"getConfigBundle").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)containerConfigClass, "config", new Modifier[0]).returns((TypeName)bundle).addCode(argumentBlock.build()).build();
            ParameterizedTypeName name = ParameterizedTypeName.get((ClassName)this.mWrapperParent, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)typeElement)});
            TypeSpec typeSpec = TypeSpec.classBuilder((String)unit.getWrapperClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)name).addMethod(superMethod).addMethod(createInstanceMethod).addMethod(getConfigBundleMethod).addMethod(getConfigBundleMethod2).build();
            JavaFile javaFile = JavaFile.builder((String)PACKAGE, (TypeSpec)typeSpec).build();
            try {
                javaFile.writeTo(this.processingEnv.getFiler());
            }
            catch (IOException iOException) {}
        }
    }

    private TypeMirror getConfigComponentClass(InitAttrConfig config) {
        try {
            config.component();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
        return null;
    }

    private ClassName getAbstractWrapper() {
        return ClassName.get((String)"com.duowan.mobile.basemedia.watchlive.template.generate", (String)"AbstractComponentWrapper", (String[])new String[0]);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private TypeSpec makeClass(String name, Modifier ... modifiers) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)name);
        builder.addModifiers(modifiers);
        return builder.build();
    }

    private FieldSpec makeField(Class type, String name, Modifier ... modifiers) {
        FieldSpec fieldSpec = FieldSpec.builder((Type)type, (String)name, (Modifier[])new Modifier[0]).addModifiers(modifiers).build();
        return fieldSpec;
    }

    private MethodSpec makeConstructors(List<ParameterSpec> parameters, List<Modifier> modifiers) {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder();
        builder.addModifiers(modifiers).addParameters(parameters);
        for (ParameterSpec parameter : parameters) {
            String name = parameter.name;
            TypeName type = parameter.type;
            type.toString();
            builder.addStatement("this.$N = $N", new Object[]{name, name});
        }
        MethodSpec flux = builder.build();
        return flux;
    }

    private MethodSpec makeMethod() {
        MethodSpec main = MethodSpec.methodBuilder((String)"main").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(Void.TYPE).addParameter(String[].class, "args", new Modifier[0]).addStatement("$T.out.println($S)", new Object[]{System.class, "Hello, JavaPoet!"}).build();
        return main;
    }

    private void getTargetClassName(String packageName, String className) {
        ClassName targetClassName = ClassName.get((String)packageName, (String)className, (String[])new String[0]);
    }

    private String getPackageName(Element element) {
        String packageName = this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName().toString();
        return packageName;
    }

    public TypeElement asTypeElement(TypeMirror typeMirror) {
        Types typeutils = this.processingEnv.getTypeUtils();
        return (TypeElement)typeutils.asElement(typeMirror);
    }

    private class ComponentArgument {
        public final TypeMirror componentCls;
        public final ExecutableElement getArgumentMethod;

        private ComponentArgument(TypeMirror componentCls, ExecutableElement getArgumentMethod) {
            this.componentCls = componentCls;
            this.getArgumentMethod = getArgumentMethod;
        }
    }
}

