/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.entlive.proccessor;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class ComponentInfo {
    private String packageName;
    private TypeElement typeElement;
    private String clsName;

    public ComponentInfo(Elements elementUtils, TypeElement classElement) {
        String packageName;
        this.typeElement = classElement;
        PackageElement packageElement = elementUtils.getPackageOf(classElement);
        this.packageName = packageName = packageElement.getQualifiedName().toString();
    }

    public void setClsName(String clsName) {
        this.clsName = clsName;
    }

    public String getClsName() {
        return this.clsName;
    }

    public String getFullClsName() {
        return this.packageName + "." + this.clsName;
    }

    public void setTypeElement(TypeElement typeElement) {
        this.typeElement = typeElement;
    }

    private String getClassName(TypeElement type, String packageName) {
        int packageLen = packageName.length() + 1;
        return type.getQualifiedName().toString().substring(packageLen).replace('.', '$');
    }

    public static void generateComponentConstantName(Filer filer, HashMap<String, ComponentInfo> componentMap) throws IOException {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)"ComponentNameCollection").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        if (!componentMap.isEmpty()) {
            for (String key : componentMap.keySet()) {
                ComponentInfo proxyInfo = componentMap.get(key);
                FieldSpec.Builder fieldBuild = FieldSpec.builder(String.class, (String)proxyInfo.getClsName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC});
                fieldBuild.initializer("\"" + proxyInfo.getFullClsName() + "\"", new Object[0]);
                classBuilder.addField(fieldBuild.build());
            }
            TypeSpec spec = classBuilder.build();
            JavaFile javaFile = JavaFile.builder((String)"com.yy.live.basic", (TypeSpec)spec).build();
            javaFile.writeTo(filer);
        }
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public String getPackageName() {
        return this.packageName;
    }
}

