/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.entlive.proccessor;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.utils.Pair;
import com.squareup.javapoet.ClassName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class RFileResolver {
    private Map<String, Map<Integer, String>> r = new LinkedHashMap<String, Map<Integer, String>>();

    public static Pair<RFileResolver, ClassName> create(Map<String, String> aptOption) throws Throwable {
        String rFilePath1 = aptOption.get("R_FILE_BEFORE_PATH");
        String rFilePath2 = aptOption.get("R_FILE_AFTER_PATH");
        String rFilePackage = aptOption.get("R_FILE_PACKAGE");
        if (rFilePath1 != null && rFilePackage == null) {
            rFilePackage = RFileResolver.readRFilePackage(rFilePath1, "packageRecord.txt");
        }
        RFileResolver rFileResolver = null;
        ClassName r = null;
        if (rFilePath1 != null && rFilePath2 != null && rFilePackage != null) {
            String rFilePath = rFilePath1 + File.separator + rFilePackage.replace(".", File.separator) + File.separator + rFilePath2;
            System.out.println("R.java package = " + rFilePackage);
            System.out.println("R.java path = " + rFilePath);
            rFileResolver = new RFileResolver(rFilePath);
            r = ClassName.get((String)rFilePackage, (String)"R", (String[])new String[0]);
        }
        return new Pair(rFileResolver, r);
    }

    public RFileResolver(String rFilePath) throws Throwable {
        this(new File(rFilePath));
    }

    public RFileResolver(File rFile) throws Throwable {
        CompilationUnit compilationUnit = JavaParser.parse((File)rFile);
        TypeDeclaration resourceClass = (TypeDeclaration)compilationUnit.getTypes().get(0);
        for (Node node : resourceClass.getChildNodes()) {
            if (!(node instanceof ClassOrInterfaceDeclaration)) continue;
            ClassOrInterfaceDeclaration cls = (ClassOrInterfaceDeclaration)node;
            String resClassify = cls.getNameAsString();
            LinkedHashMap<Integer, String> idToName = new LinkedHashMap<Integer, String>();
            for (BodyDeclaration field : cls.getMembers()) {
                FieldDeclaration declaration;
                if (!(field instanceof FieldDeclaration) || !RFileResolver.isInt(declaration = (FieldDeclaration)field)) continue;
                VariableDeclarator variable = (VariableDeclarator)declaration.getVariables().get(0);
                final String fieldName = variable.getNameAsString();
                String fieldValue = variable.getInitializer().map(new Function<Expression, String>(){

                    @Override
                    public String apply(Expression expression) {
                        return expression.toString();
                    }
                }).orElseThrow(new Supplier<Throwable>(){

                    @Override
                    public Throwable get() {
                        return new IllegalStateException("Field " + fieldName + " missing initializer");
                    }
                });
                try {
                    if (!fieldValue.startsWith("0x")) continue;
                    fieldValue = fieldValue.substring(2);
                    Integer resId = Integer.parseInt(fieldValue, 16);
                    idToName.put(resId, fieldName);
                }
                catch (NumberFormatException e) {
                    System.out.println("error " + e);
                }
            }
            this.r.put(resClassify, idToName);
        }
    }

    public String getFieldName(String classify, int resId) {
        return this.r.get(classify).get(resId);
    }

    private static boolean isInt(FieldDeclaration field) {
        Type type = field.getCommonType();
        return type instanceof PrimitiveType && ((PrimitiveType)type).getType() == PrimitiveType.Primitive.INT;
    }

    private static String readRFilePackage(String dir, String fileName) {
        File file = new File(dir, fileName);
        try {
            if (file.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String rPackage = reader.readLine();
                reader.close();
                return rPackage;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

