/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.entlive.proccessor;

import com.duowan.mobile.entlive.domain.IEntModule;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class ModuleProxyInfo {
    private String packageName;
    private String proxyClassName;
    private TypeElement typeElement;
    private String clsName;
    public static final String PROXY = "ModuleProxy";

    public ModuleProxyInfo(Elements elementUtils, TypeElement classElement) {
        this.typeElement = classElement;
        PackageElement packageElement = elementUtils.getPackageOf(classElement);
        String packageName = packageElement.getQualifiedName().toString();
        String className = this.getClassName(classElement, packageName);
        this.packageName = packageName;
        this.proxyClassName = className + "$$" + PROXY;
    }

    public void setClsName(String clsName) {
        this.clsName = clsName;
    }

    public String getClsName() {
        return this.clsName;
    }

    public String getFullClsName() {
        return this.packageName + "." + this.clsName;
    }

    public void setTypeElement(TypeElement typeElement) {
        this.typeElement = typeElement;
    }

    private String getClassName(TypeElement type, String packageName) {
        int packageLen = packageName.length() + 1;
        return type.getQualifiedName().toString().substring(packageLen).replace('.', '$');
    }

    public void generateModuleProxyClass(Filer filer) throws IOException {
        MethodSpec getModule = MethodSpec.methodBuilder((String)"getModule").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(IEntModule.class).addStatement("return new $T()", new Object[]{this.typeElement}).build();
        ClassName interfaceClass = ClassName.get((String)"com.duowan.mobile.entlive.domain", (String)"IModuleProxy", (String[])new String[0]);
        TypeSpec proxy = TypeSpec.classBuilder((String)this.proxyClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)interfaceClass).addMethod(getModule).build();
        JavaFile javaFile = JavaFile.builder((String)this.packageName, (TypeSpec)proxy).build();
        javaFile.writeTo(filer);
    }

    public static void generateModuleProxyContainer(Filer filer, HashMap<String, ModuleProxyInfo> modulesProxyMap) throws IOException {
        if (modulesProxyMap.isEmpty()) {
            return;
        }
        CodeBlock.Builder builder = CodeBlock.builder();
        for (String key : modulesProxyMap.keySet()) {
            ModuleProxyInfo proxyInfo = modulesProxyMap.get(key);
            builder.addStatement("moduleMap.put($S,new $T().getModule())", new Object[]{proxyInfo.getFullClsName(), ClassName.get((String)proxyInfo.getPackageName(), (String)proxyInfo.getProxyClassName(), (String[])new String[0])});
        }
        MethodSpec initModule = MethodSpec.methodBuilder((String)"init").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.VOID).addCode(builder.build()).build();
        MethodSpec getModule = MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(IEntModule.class).addParameter(String.class, "cls", new Modifier[0]).addStatement("return moduleMap.get(cls)", new Object[0]).build();
        MethodSpec removeModule = MethodSpec.methodBuilder((String)"remove").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(IEntModule.class).addParameter(String.class, "cls", new Modifier[0]).addStatement("return moduleMap.remove(cls)", new Object[0]).build();
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(initModule);
        methods.add(getModule);
        methods.add(removeModule);
        FieldSpec.Builder fieldBuild = FieldSpec.builder((TypeName)ParameterizedTypeName.get(HashMap.class, (Type[])new Type[]{String.class, IEntModule.class}), (String)"moduleMap", (Modifier[])new Modifier[]{Modifier.PRIVATE});
        fieldBuild.initializer("new HashMap<>()", new Object[0]);
        TypeSpec proxy = TypeSpec.classBuilder((String)"ModuleProxyFactory").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethods(methods).addField(fieldBuild.build()).build();
        JavaFile javaFile = JavaFile.builder((String)"com.yy.live.basic", (TypeSpec)proxy).build();
        javaFile.writeTo(filer);
    }

    public static void generateModulesConstantName(Filer filer, HashMap<String, ModuleProxyInfo> modulesProxyMap) throws IOException {
        if (!modulesProxyMap.isEmpty()) {
            TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)"ModulesNameCollection").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            FieldSpec.Builder fieldBuild = FieldSpec.builder(String.class, (String)"All", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC});
            fieldBuild.initializer("\"*\"", new Object[0]);
            classBuilder.addField(fieldBuild.build());
            for (String key : modulesProxyMap.keySet()) {
                ModuleProxyInfo proxyInfo = modulesProxyMap.get(key);
                fieldBuild = FieldSpec.builder(String.class, (String)proxyInfo.getClsName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC});
                fieldBuild.initializer("\"" + proxyInfo.getFullClsName() + "\"", new Object[0]);
                classBuilder.addField(fieldBuild.build());
            }
            TypeSpec spec = classBuilder.build();
            JavaFile javaFile = JavaFile.builder((String)"com.yy.live.basic", (TypeSpec)spec).build();
            javaFile.writeTo(filer);
        }
    }

    public String getProxyClassFullName() {
        return this.packageName + "." + this.proxyClassName;
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public String getProxyClassName() {
        return this.proxyClassName;
    }

    public String getPackageName() {
        return this.packageName;
    }
}

