/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.liveapi.plugincenter;

import android.os.Bundle;
import android.support.annotation.NonNull;
import com.google.gson.annotations.SerializedName;
import com.yy.mobile.plugin.PluginCenter;
import com.yy.mobile.plugin.PluginInfo;
import com.yy.mobile.plugin.Plugins;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yymobile.liveapi.plugincenter.event.LoadPluginListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class SinglePluginInfo {
    @SerializedName(value="pluginId")
    public long pluginId;
    @SerializedName(value="pluginName")
    public String pluginName = "";
    @SerializedName(value="icon")
    public String icon = "";
    @SerializedName(value="showIcon")
    public boolean showIcon;
    @SerializedName(value="mutexGroupId")
    public long mutexGroupId;
    @SerializedName(value="living")
    public boolean living;
    public String payload = "";
    public HashMap<String, String> msgType;
    @SerializedName(value="pluginConfig")
    public PluginConfig pluginConfig;
    public boolean isPositive;
    @SerializedName(value="isNewPlugin")
    public boolean isNewPlugin;
    @SerializedName(value="extendString")
    public String extendInfo;
    public transient Bundle extend;
    @Deprecated
    public LoadPluginListener loadPluginListener;
    public List<LoadPluginListener> mLoadPluginListenerList;

    public SinglePluginInfo() {
    }

    public SinglePluginInfo(@NonNull SinglePluginInfo info) {
        this.deepCopy(info, false);
    }

    public SinglePluginInfo(@NonNull SinglePluginInfo info, boolean isCopyReference) {
        this.deepCopy(info, isCopyReference);
    }

    public void addLoadingListener(LoadPluginListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mLoadPluginListenerList == null) {
            this.mLoadPluginListenerList = new ArrayList<LoadPluginListener>();
        }
        if (!this.mLoadPluginListenerList.contains(listener)) {
            this.mLoadPluginListenerList.add(listener);
        }
    }

    public void removeLoadingListener(LoadPluginListener listener) {
        if (listener == null || FP.empty(this.mLoadPluginListenerList)) {
            return;
        }
        this.mLoadPluginListenerList.remove(listener);
    }

    public void onFinish(final SinglePluginInfo pluginInfo, final LoadPluginListener.Result result) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!FP.empty(SinglePluginInfo.this.mLoadPluginListenerList)) {
                    for (LoadPluginListener listener : SinglePluginInfo.this.mLoadPluginListenerList) {
                        if (listener == null) continue;
                        listener.onFinish(pluginInfo, result);
                    }
                }
                if (SinglePluginInfo.this.loadPluginListener != null) {
                    SinglePluginInfo.this.loadPluginListener.onFinish(pluginInfo, result);
                }
            }
        }, (long)0L);
    }

    private void deepCopy(@NonNull SinglePluginInfo info, boolean isCopyReference) {
        this.pluginId = info.pluginId;
        this.pluginName = this.nonNullString(info.pluginName);
        this.icon = this.nonNullString(info.icon);
        this.showIcon = info.showIcon;
        this.mutexGroupId = info.mutexGroupId;
        this.living = info.living;
        this.payload = this.nonNullString(info.payload);
        this.extendInfo = info.extendInfo;
        if (info.msgType != null) {
            this.msgType = new HashMap<String, String>(info.msgType);
        }
        this.setAndroidId(this.nonNullString(info.getAndroidId()));
        this.setVersion(info.getVersion());
        this.isPositive = info.isPositive;
        if (info.extend != null) {
            this.extend = new Bundle(info.extend);
        }
        this.isNewPlugin = info.isNewPlugin;
        if (isCopyReference) {
            this.loadPluginListener = info.loadPluginListener;
            if (info.mLoadPluginListenerList != null) {
                this.mLoadPluginListenerList = new ArrayList<LoadPluginListener>(info.mLoadPluginListenerList);
            }
        }
    }

    @NonNull
    protected String nonNullString(String s) {
        return s == null ? "" : s;
    }

    public String toString() {
        return "SinglePluginInfo {pluginId=" + this.pluginId + ", pluginName='" + this.pluginName + '\'' + ", icon='" + this.icon + '\'' + ", showIcon=" + this.showIcon + ", mutexGroupId=" + this.mutexGroupId + ", living=" + this.living + ", payload='" + this.payload + '\'' + ", msgType=" + this.msgType + ", androidId='" + this.getAndroidId() + '\'' + ", androidVersion='" + this.getVersion() + '\'' + ", isPositive=" + this.isPositive + ", extend=" + this.extend + ", isNewPlugin=" + this.isNewPlugin + "}";
    }

    public String getAndroidId() {
        if (this.pluginConfig == null || this.pluginConfig.androidInfo == null) {
            return "";
        }
        return this.pluginConfig.androidInfo.androidId;
    }

    public void setAndroidId(String androidId) {
        if (this.pluginConfig == null) {
            this.pluginConfig = new PluginConfig();
        }
        if (this.pluginConfig.androidInfo == null) {
            this.pluginConfig.androidInfo = new AndroidInfo();
        }
        this.pluginConfig.androidInfo.androidId = androidId;
    }

    public String getVersion() {
        if (this.pluginConfig == null || this.pluginConfig.androidInfo == null) {
            return "";
        }
        return this.pluginConfig.androidInfo.version;
    }

    public void setVersion(String version) {
        if (this.pluginConfig == null) {
            this.pluginConfig = new PluginConfig();
        }
        if (this.pluginConfig.androidInfo == null) {
            this.pluginConfig.androidInfo = new AndroidInfo();
        }
        this.pluginConfig.androidInfo.version = version;
    }

    @Nonnull
    public Map<String, String> getPluginCenterActionMap() {
        Plugins pi = Plugins.fromPluginId((String)this.getAndroidId());
        return pi != null ? pi.pluginCenterActionMap() : PluginCenter.defaultActionMap();
    }

    public boolean isMultiActiveSupport() {
        Plugins pi = Plugins.fromPluginId((String)this.getAndroidId());
        return pi != null && pi.activeMode() == PluginInfo.ActiveMode.MULTI;
    }

    public static class AndroidInfo {
        @SerializedName(value="id")
        public String androidId;
        @SerializedName(value="version")
        public String version;
    }

    public static class PluginConfig {
        @SerializedName(value="android")
        public AndroidInfo androidInfo;
    }
}

