/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.liveapi.necklace;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import com.yy.mobile.util.ActivityUtilKt;

public class PopupWindows {
    protected Context mContext;
    protected PopupWindow mWindow;
    private RootView mRootViewWrapper;
    protected View mRootView;
    protected Drawable mBackground = null;
    protected WindowManager mWindowManager;
    public PopupWindow.OnDismissListener mDismissListener;

    public PopupWindows(Context context) {
        this.mContext = context;
        this.mWindow = new PopupWindow(context);
        this.mWindow.setTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 4) {
                    PopupWindows.this.mWindow.dismiss();
                    return false;
                }
                return false;
            }
        });
        this.mWindowManager = (WindowManager)context.getSystemService("window");
    }

    protected void onDismiss() {
    }

    protected void onPreShow() {
    }

    protected void preShow() {
        if (this.mRootViewWrapper == null) {
            throw new IllegalStateException("setContentView was not called with a view to display.");
        }
        this.onPreShow();
        if (this.mBackground == null) {
            this.mWindow.setBackgroundDrawable((Drawable)new BitmapDrawable());
        } else {
            this.mWindow.setBackgroundDrawable(this.mBackground);
        }
        this.mWindow.setWidth(-2);
        this.mWindow.setHeight(-2);
        this.mWindow.setTouchable(true);
        this.mWindow.setOutsideTouchable(true);
        this.mWindow.setContentView((View)this.mRootViewWrapper);
    }

    public void setBackgroundDrawable(Drawable background) {
        this.mBackground = background;
    }

    public void setContentView(View root) {
        if (root == null) {
            throw new IllegalStateException("setContentView was not called with a view to display.");
        }
        this.mRootViewWrapper = new RootView(this.mContext);
        this.mRootViewWrapper.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mRootView = root;
        this.mRootViewWrapper.addView(root);
        this.mWindow.setContentView((View)this.mRootViewWrapper);
        this.mWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                PopupWindows.this.onDismiss();
                if (PopupWindows.this.mDismissListener != null) {
                    PopupWindows.this.mDismissListener.onDismiss();
                }
            }
        });
    }

    public void setContentView(int layoutResID) {
        LayoutInflater inflator = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.setContentView(inflator.inflate(layoutResID, null));
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener listener) {
        this.mDismissListener = listener;
    }

    public void dismiss() {
        if (Build.VERSION.SDK_INT >= 17) {
            if (this.mContext instanceof Activity && ActivityUtilKt.isValid((Activity)((Activity)this.mContext))) {
                this.mWindow.dismiss();
            }
        } else {
            this.mWindow.dismiss();
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
    }

    public class RootView
    extends FrameLayout {
        public RootView(Context context) {
            super(context);
        }

        public RootView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected void onConfigurationChanged(Configuration newConfig) {
            if (PopupWindows.this.mWindow != null && PopupWindows.this.mWindow.isShowing()) {
                PopupWindows.this.mWindow.dismiss();
            }
            PopupWindows.this.onConfigurationChanged(newConfig);
        }
    }
}

