/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.base.utils;

import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class DensityUtils {
    private DensityUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static int dp2px(float dpVal) {
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static float dp2pxFloat(float dpVal) {
        return TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static int sp2px(float spVal) {
        return (int)TypedValue.applyDimension((int)2, (float)spVal, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static float px2dp(float pxVal) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return pxVal / scale;
    }

    public static float px2sp(float pxVal) {
        return pxVal / Resources.getSystem().getDisplayMetrics().scaledDensity;
    }
}

