/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.base.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.util.log.MLog;
import java.io.Serializable;

public abstract class WrapperComponent
extends Component {
    private static final String TAG = "WrapperPopupCompoent";
    public static final String ARG_ITEM = "arg_item";
    public View mContentView;
    public Activity mActivity;

    public static <T extends Fragment> T newInstance(Class<T> clz) {
        Bundle bundle = new Bundle();
        Fragment fragment = null;
        try {
            fragment = (Fragment)clz.newInstance();
            fragment.setArguments(bundle);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return (T)fragment;
    }

    public static <T extends Fragment> T newInstance(Class<T> clz, Serializable value) {
        Bundle bundle = new Bundle();
        bundle.putSerializable(ARG_ITEM, value);
        Fragment fragment = null;
        try {
            fragment = (Fragment)clz.newInstance();
            fragment.setArguments(bundle);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return (T)fragment;
    }

    public static <T extends Fragment> T newInstance(Class<T> clz, Parcelable value) {
        Bundle bundle = new Bundle();
        bundle.putParcelable(ARG_ITEM, value);
        Fragment fragment = null;
        try {
            fragment = (Fragment)clz.newInstance();
            fragment.setArguments(bundle);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return (T)fragment;
    }

    private static String getClassName() {
        String result = "";
        StackTraceElement thisMethodStack = new Exception().getStackTrace()[2];
        result = "[aa] " + thisMethodStack.getClassName();
        return result;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mActivity = activity;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initVariable(savedInstanceState);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mContentView = LayoutInflater.from((Context)this.getActivity()).inflate(this.getLayout(), null);
        return this.mContentView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initViewAndData();
        this.initListener();
    }

    public abstract int getLayout();

    public abstract void initVariable(@Nullable Bundle var1);

    public abstract void initViewAndData();

    public abstract void initListener();

    protected <VT extends View> VT f(@IdRes int id) {
        return (VT)this.mContentView.findViewById(id);
    }

    protected <VT extends Activity> VT activity() {
        return (VT)this.mActivity;
    }

    public LayoutInflater inflater() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mActivity);
        return layoutInflater;
    }

    public void log(String message) {
        try {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            String methodname = stackTraceElement.getMethodName();
            MLog.info((Object)methodname, (String)message, (Object[])new Object[0]);
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)("log message:" + message), (Object[])new Object[0]);
        }
    }
}

