/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.liveapi.necklace;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.liveapi.necklace.PopupWindows;
import com.yy.mobile.util.ActivityUtilKt;

public class BasePopWindow
extends PopupWindows {
    protected Rect mWindowInfoRect = new Rect();
    protected boolean isTop = false;
    protected Point mScreenSize = new Point();
    protected int mShadowMargin = 0;
    private int rootWidth;
    private int rootHeight;
    protected Rect anchorRect;
    protected static int mPopupLeftRightMargin = UIUtil.dpToPx(10);
    protected static int mPopupTopBottomMargin = UIUtil.dpToPx(10);

    public BasePopWindow(Context context) {
        super(context);
    }

    public void show(View parent, Rect rect, boolean topFirst) {
        this.preShow();
        this.anchorRect = rect;
        Display screenDisplay = this.mWindowManager.getDefaultDisplay();
        screenDisplay.getSize(this.mScreenSize);
        this.measureForShow();
        this.mWindow.setWidth(this.rootWidth);
        this.mWindow.setHeight(this.rootHeight);
        this.calculateXPos();
        this.calculateYPos(topFirst);
        this.isTop = this.mWindowInfoRect.top > this.anchorRect.top;
        this.showArrow(this.isTop);
        this.setAnimationStyle(this.mScreenSize.x, this.anchorRect.centerX(), this.isTop);
        if (this.mContext instanceof Activity && ActivityUtilKt.isValid((Activity)((Activity)this.mContext))) {
            this.mWindow.showAtLocation(parent, 0, this.mWindowInfoRect.left, this.mWindowInfoRect.top);
        }
        this.onAfterShow();
    }

    protected final int[] measureForShow() {
        int[] rootWH = this.onMeasureForShow();
        this.rootWidth = rootWH[0];
        this.rootHeight = rootWH[1];
        ViewGroup.LayoutParams lp = this.mRootView.getLayoutParams();
        lp.width = this.rootWidth;
        lp.height = this.rootHeight;
        this.mRootView.setLayoutParams(lp);
        return rootWH;
    }

    protected final void calculateXPos() {
        this.mWindowInfoRect.left = this.onCalculateXPos(this.mScreenSize.x, this.rootWidth, this.anchorRect, mPopupLeftRightMargin);
        if (this.mWindowInfoRect.left > this.mScreenSize.x - this.rootWidth) {
            this.mWindowInfoRect.left = this.mScreenSize.x - this.rootWidth;
        }
        this.mWindowInfoRect.right = this.mWindowInfoRect.left + this.rootWidth;
    }

    protected final void calculateYPos(boolean topFirst) {
        this.mWindowInfoRect.top = this.onCalculateYPos(this.mScreenSize.y, this.rootHeight, this.anchorRect, mPopupTopBottomMargin, topFirst);
        if (this.mWindowInfoRect.top > this.mScreenSize.y - this.rootHeight) {
            this.mWindowInfoRect.top = this.mScreenSize.y - this.rootHeight;
        }
        this.mWindowInfoRect.bottom = this.mWindowInfoRect.top + this.rootHeight;
    }

    protected int[] onMeasureForShow() {
        this.mRootView.measure(-2, -2);
        return new int[]{this.mRootView.getMeasuredWidth(), this.mRootView.getMeasuredHeight()};
    }

    protected int onCalculateXPos(int parentWidth, int rootWidth, Rect anchorRect, int paddingHorizontal) {
        int anchorCenterX = anchorRect.centerX();
        int xPos = anchorCenterX - rootWidth / 2 >= 0 && anchorCenterX + rootWidth / 2 < parentWidth ? anchorCenterX - rootWidth / 2 : (anchorRect.centerX() <= parentWidth / 2 ? 0 : parentWidth - rootWidth);
        return xPos;
    }

    protected int onCalculateYPos(int parentHeight, int rootHeight, Rect anchorRect, int paddingVertical, boolean topFirst) {
        int yPos = anchorRect.top <= paddingVertical + rootHeight ? anchorRect.bottom + this.mShadowMargin : (parentHeight - anchorRect.bottom <= paddingVertical + rootHeight ? anchorRect.top - rootHeight - this.mShadowMargin : (topFirst ? anchorRect.top - rootHeight - this.mShadowMargin : anchorRect.bottom + this.mShadowMargin));
        return yPos;
    }

    protected void onAfterShow() {
    }

    protected void setAnimationStyle(int screenWidth, int requestedX, boolean onTop) {
    }

    protected void showArrow(boolean isTop) {
    }

    protected void update() {
        this.mWindow.update(this.mWindowInfoRect.left, this.mWindowInfoRect.top, this.mWindowInfoRect.width(), this.mWindowInfoRect.height());
    }

    private static class UIUtil {
        private UIUtil() {
        }

        static int dpToPx(int dp) {
            return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
        }
    }
}

