/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.ipcapi.receiver;

import com.unionyy.ipcapi.receiver.Receiver;
import com.unionyy.ipcapi.util.HermesException;
import com.unionyy.ipcapi.util.TypeUtils;
import com.unionyy.ipcapi.wrapper.MethodWrapper;
import com.unionyy.ipcapi.wrapper.ObjectWrapper;
import com.unionyy.ipcapi.wrapper.ParameterWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class UtilityReceiver
extends Receiver {
    private Method mMethod;
    private Class<?> mClass;

    public UtilityReceiver(ObjectWrapper objectWrapper) throws HermesException {
        super(objectWrapper);
        Class<?> clazz = TYPE_CENTER.getClassType(objectWrapper);
        TypeUtils.validateAccessible(clazz);
        this.mClass = clazz;
    }

    @Override
    protected void setMethod(MethodWrapper methodWrapper, ParameterWrapper[] parameterWrappers) throws HermesException {
        Method method = TYPE_CENTER.getMethod(this.mClass, methodWrapper);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new HermesException(5, "Only static methods can be invoked on the utility class " + this.mClass.getName() + ". Please modify the method: " + this.mMethod);
        }
        TypeUtils.validateAccessible(method);
        this.mMethod = method;
    }

    @Override
    protected Object invokeMethod() throws HermesException {
        ReflectiveOperationException exception;
        try {
            return this.mMethod.invoke(null, this.getParameters());
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        exception.printStackTrace();
        throw new HermesException(18, "Error occurs when invoking method " + this.mMethod + ".", exception);
    }
}

