/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.ipcapi.receiver;

import android.content.Context;
import com.unionyy.ipcapi.Hermes;
import com.unionyy.ipcapi.internal.HermesCallbackInvocationHandler;
import com.unionyy.ipcapi.internal.IHermesServiceCallback;
import com.unionyy.ipcapi.internal.Reply;
import com.unionyy.ipcapi.util.CodeUtils;
import com.unionyy.ipcapi.util.HermesCallbackGc;
import com.unionyy.ipcapi.util.HermesException;
import com.unionyy.ipcapi.util.ObjectCenter;
import com.unionyy.ipcapi.util.TypeCenter;
import com.unionyy.ipcapi.wrapper.MethodWrapper;
import com.unionyy.ipcapi.wrapper.ObjectWrapper;
import com.unionyy.ipcapi.wrapper.ParameterWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public abstract class Receiver {
    protected static final ObjectCenter OBJECT_CENTER = ObjectCenter.getInstance();
    protected static final TypeCenter TYPE_CENTER = TypeCenter.getInstance();
    protected static final HermesCallbackGc HERMES_CALLBACK_GC = HermesCallbackGc.getInstance();
    private long mObjectTimeStamp;
    private Object[] mParameters;
    private IHermesServiceCallback mCallback;

    public Receiver(ObjectWrapper objectWrapper) {
        this.mObjectTimeStamp = objectWrapper.getTimeStamp();
    }

    protected long getObjectTimeStamp() {
        return this.mObjectTimeStamp;
    }

    protected Object[] getParameters() {
        return this.mParameters;
    }

    public void setHermesServiceCallback(IHermesServiceCallback callback) {
        this.mCallback = callback;
    }

    private Object getProxy(Class<?> clazz, int index, long methodInvocationTimeStamp) {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new HermesCallbackInvocationHandler(methodInvocationTimeStamp, index, this.mCallback));
    }

    private static void registerCallbackReturnTypes(Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            TYPE_CENTER.register(method.getReturnType());
        }
    }

    private void setParameters(long methodInvocationTimeStamp, ParameterWrapper[] parameterWrappers) throws HermesException {
        if (parameterWrappers == null) {
            this.mParameters = null;
        } else {
            int length = parameterWrappers.length;
            this.mParameters = new Object[length];
            for (int i = 0; i < length; ++i) {
                String data;
                ParameterWrapper parameterWrapper = parameterWrappers[i];
                if (parameterWrapper == null) {
                    this.mParameters[i] = null;
                    continue;
                }
                Class<?> clazz = TYPE_CENTER.getClassType(parameterWrapper);
                if (clazz != null && clazz.isInterface()) {
                    Receiver.registerCallbackReturnTypes(clazz);
                    this.mParameters[i] = this.getProxy(clazz, i, methodInvocationTimeStamp);
                    HERMES_CALLBACK_GC.register(this.mCallback, this.mParameters[i], methodInvocationTimeStamp, i);
                    continue;
                }
                this.mParameters[i] = clazz != null && Context.class.isAssignableFrom(clazz) ? Hermes.getContext() : ((data = parameterWrapper.getData()) == null ? null : CodeUtils.decode(data, clazz));
            }
        }
    }

    protected abstract void setMethod(MethodWrapper var1, ParameterWrapper[] var2) throws HermesException;

    protected abstract Object invokeMethod() throws HermesException;

    public final Reply action(long methodInvocationTimeStamp, MethodWrapper methodWrapper, ParameterWrapper[] parameterWrappers) throws HermesException {
        this.setMethod(methodWrapper, parameterWrappers);
        this.setParameters(methodInvocationTimeStamp, parameterWrappers);
        Object result = this.invokeMethod();
        if (result == null) {
            return null;
        }
        return new Reply(new ParameterWrapper(result));
    }
}

