/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.ipcapi.wrapper;

import android.os.Parcel;
import android.os.Parcelable;
import com.unionyy.ipcapi.util.TimeStampGenerator;
import com.unionyy.ipcapi.util.TypeUtils;
import com.unionyy.ipcapi.wrapper.BaseWrapper;

public class ObjectWrapper
extends BaseWrapper
implements Parcelable {
    public static final int TYPE_OBJECT_TO_NEW = 0;
    public static final int TYPE_OBJECT_TO_GET = 1;
    public static final int TYPE_OBJECT = 3;
    public static final int TYPE_CLASS = 4;
    public static final int TYPE_CLASS_TO_GET = 5;
    private long mTimeStamp;
    private Class<?> mClass;
    private int mType;
    public static final Parcelable.Creator<ObjectWrapper> CREATOR = new Parcelable.Creator<ObjectWrapper>(){

        public ObjectWrapper createFromParcel(Parcel in) {
            ObjectWrapper objectWrapper = new ObjectWrapper();
            objectWrapper.readFromParcel(in);
            return objectWrapper;
        }

        public ObjectWrapper[] newArray(int size) {
            return new ObjectWrapper[size];
        }
    };

    private ObjectWrapper() {
    }

    public ObjectWrapper(Class<?> clazz, int type) {
        String classId = TypeUtils.getClassId(clazz);
        if (classId == null) {
            this.setName(true, clazz.getName());
        } else {
            this.setName(false, classId);
        }
        this.mClass = clazz;
        this.mTimeStamp = TimeStampGenerator.getTimeStamp();
        this.mType = type;
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        super.writeToParcel(parcel, flags);
        parcel.writeLong(this.mTimeStamp);
        parcel.writeInt(this.mType);
    }

    @Override
    public void readFromParcel(Parcel in) {
        super.readFromParcel(in);
        this.mTimeStamp = in.readLong();
        this.mType = in.readInt();
    }

    public long getTimeStamp() {
        return this.mTimeStamp;
    }

    public Class<?> getObjectClass() {
        return this.mClass;
    }

    public void setType(int type) {
        this.mType = type;
    }

    public int getType() {
        return this.mType;
    }
}

