/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.ipcapi.util;

import android.util.Log;
import android.util.Pair;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;

public class CallbackManager {
    private static final String TAG = "CallbackManager";
    private static final int MAX_INDEX = 10;
    private static volatile CallbackManager sInstance = null;
    private final ConcurrentHashMap<Long, CallbackWrapper> mCallbackWrappers = new ConcurrentHashMap();

    private CallbackManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CallbackManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<CallbackManager> clazz = CallbackManager.class;
        synchronized (CallbackManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new CallbackManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private static long getKey(long timeStamp, int index) {
        if (index >= 10) {
            throw new IllegalArgumentException("Index should be less than 10");
        }
        return timeStamp * 10L + (long)index;
    }

    public void addCallback(long timeStamp, int index, Object callback, boolean isWeakRef, boolean uiThread) {
        long key = CallbackManager.getKey(timeStamp, index);
        this.mCallbackWrappers.put(key, new CallbackWrapper(isWeakRef, callback, uiThread));
    }

    public Pair<Boolean, Object> getCallback(long timeStamp, int index) {
        long key = CallbackManager.getKey(timeStamp, index);
        CallbackWrapper callbackWrapper = this.mCallbackWrappers.get(key);
        if (callbackWrapper == null) {
            return null;
        }
        Pair<Boolean, Object> pair = callbackWrapper.get();
        if (pair.second == null) {
            this.mCallbackWrappers.remove(key);
        }
        return pair;
    }

    public void removeCallback(long timeStamp, int index) {
        long key = CallbackManager.getKey(timeStamp, index);
        if (this.mCallbackWrappers.remove(key) == null) {
            Log.e((String)TAG, (String)"An error occurs in the callback GC.");
        }
    }

    private static class CallbackWrapper {
        private Object mCallback;
        private boolean mUiThread;

        CallbackWrapper(boolean isWeakRef, Object callback, boolean uiThread) {
            this.mCallback = isWeakRef ? new WeakReference<Object>(callback) : callback;
            this.mUiThread = uiThread;
        }

        public Pair<Boolean, Object> get() {
            Object callback = this.mCallback instanceof WeakReference ? ((WeakReference)this.mCallback).get() : this.mCallback;
            return new Pair((Object)this.mUiThread, callback);
        }
    }
}

