/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.ipcapi.internal;

import android.os.Parcel;
import android.os.Parcelable;
import com.unionyy.ipcapi.util.CodeUtils;
import com.unionyy.ipcapi.util.HermesException;
import com.unionyy.ipcapi.util.TypeCenter;
import com.unionyy.ipcapi.wrapper.ParameterWrapper;
import com.unionyy.ipcapi.wrapper.TypeWrapper;

public class Reply
implements Parcelable {
    private static final TypeCenter TYPE_CENTER = TypeCenter.getInstance();
    private int mErrorCode;
    private String mErrorMessage;
    private TypeWrapper mClass;
    private Object mResult;
    public static final Parcelable.Creator<Reply> CREATOR = new Parcelable.Creator<Reply>(){

        public Reply createFromParcel(Parcel in) {
            Reply reply = new Reply();
            reply.readFromParcel(in);
            return reply;
        }

        public Reply[] newArray(int size) {
            return new Reply[size];
        }
    };

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mErrorCode);
        parcel.writeString(this.mErrorMessage);
        parcel.writeParcelable((Parcelable)this.mClass, flags);
        try {
            parcel.writeString(CodeUtils.encode(this.mResult));
        }
        catch (HermesException e) {
            e.printStackTrace();
        }
    }

    public void readFromParcel(Parcel in) {
        this.mErrorCode = in.readInt();
        ClassLoader classLoader = Reply.class.getClassLoader();
        this.mErrorMessage = in.readString();
        this.mClass = (TypeWrapper)in.readParcelable(classLoader);
        try {
            Class<?> clazz = TYPE_CENTER.getClassType(this.mClass);
            this.mResult = CodeUtils.decode(in.readString(), clazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Reply() {
    }

    public Reply(ParameterWrapper parameterWrapper) {
        try {
            Class<?> clazz = TYPE_CENTER.getClassType(parameterWrapper);
            this.mResult = CodeUtils.decode(parameterWrapper.getData(), clazz);
            this.mErrorCode = 0;
            this.mErrorMessage = null;
            this.mClass = new TypeWrapper(clazz);
        }
        catch (HermesException e) {
            e.printStackTrace();
            this.mErrorCode = e.getErrorCode();
            this.mErrorMessage = e.getMessage();
            this.mResult = null;
            this.mClass = null;
        }
    }

    public Reply(int errorCode, String message) {
        this.mErrorCode = errorCode;
        this.mErrorMessage = message;
        this.mResult = null;
        this.mClass = null;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public boolean success() {
        return this.mErrorCode == 0;
    }

    public String getMessage() {
        return this.mErrorMessage;
    }

    public Object getResult() {
        return this.mResult;
    }
}

