/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.ipcapi.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.unionyy.ipcapi.HermesListener;
import com.unionyy.ipcapi.HermesService;
import com.unionyy.ipcapi.internal.CallbackMail;
import com.unionyy.ipcapi.internal.IHermesService;
import com.unionyy.ipcapi.internal.IHermesServiceCallback;
import com.unionyy.ipcapi.internal.Mail;
import com.unionyy.ipcapi.internal.Reply;
import com.unionyy.ipcapi.util.CallbackManager;
import com.unionyy.ipcapi.util.CodeUtils;
import com.unionyy.ipcapi.util.HermesException;
import com.unionyy.ipcapi.util.TypeCenter;
import com.unionyy.ipcapi.wrapper.ParameterWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class Channel {
    private static final String TAG = "CHANNEL";
    private static volatile Channel sInstance = null;
    private final ConcurrentHashMap<Class<? extends HermesService>, IHermesService> mHermesServices = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends HermesService>, HermesServiceConnection> mHermesServiceConnections = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends HermesService>, Boolean> mBindings = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends HermesService>, Boolean> mBounds = new ConcurrentHashMap();
    private HermesListener mListener = null;
    private Handler mUiHandler = new Handler(Looper.getMainLooper());
    private static final CallbackManager CALLBACK_MANAGER = CallbackManager.getInstance();
    private static final TypeCenter TYPE_CENTER = TypeCenter.getInstance();
    private IHermesServiceCallback mHermesServiceCallback = new IHermesServiceCallback.Stub(){

        private Object[] getParameters(ParameterWrapper[] parameterWrappers) throws HermesException {
            if (parameterWrappers == null) {
                parameterWrappers = new ParameterWrapper[]{};
            }
            int length = parameterWrappers.length;
            Object[] result = new Object[length];
            for (int i = 0; i < length; ++i) {
                ParameterWrapper parameterWrapper = parameterWrappers[i];
                if (parameterWrapper == null) {
                    result[i] = null;
                    continue;
                }
                Class<?> clazz = TYPE_CENTER.getClassType(parameterWrapper);
                String data = parameterWrapper.getData();
                result[i] = data == null ? null : CodeUtils.decode(data, clazz);
            }
            return result;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Reply callback(CallbackMail mail) {
            Pair<Boolean, Object> pair = CALLBACK_MANAGER.getCallback(mail.getTimeStamp(), mail.getIndex());
            if (pair == null) {
                return null;
            }
            final Object callback = pair.second;
            if (callback == null) {
                return new Reply(22, "");
            }
            boolean uiThread = (Boolean)pair.first;
            try {
                final Method method = TYPE_CENTER.getMethod(callback.getClass(), mail.getMethod());
                final Object[] parameters = this.getParameters(mail.getParameters());
                Object result = null;
                ReflectiveOperationException exception = null;
                if (uiThread) {
                    boolean isMainThread;
                    boolean bl = isMainThread = Looper.getMainLooper() == Looper.myLooper();
                    if (!isMainThread) {
                        Channel.this.mUiHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    method.invoke(callback, parameters);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        return null;
                    }
                    try {
                        result = method.invoke(callback, parameters);
                    }
                    catch (IllegalAccessException e) {
                        exception = e;
                    }
                    catch (InvocationTargetException e) {
                        exception = e;
                    }
                } else {
                    try {
                        result = method.invoke(callback, parameters);
                    }
                    catch (IllegalAccessException e) {
                        exception = e;
                    }
                    catch (InvocationTargetException e) {
                        exception = e;
                    }
                }
                if (exception != null) {
                    exception.printStackTrace();
                    throw new HermesException(18, "Error occurs when invoking method " + method + " on " + callback, exception);
                }
                if (result == null) {
                    return null;
                }
                return new Reply(new ParameterWrapper(result));
            }
            catch (HermesException e) {
                e.printStackTrace();
                return new Reply(e.getErrorCode(), e.getErrorMessage());
            }
        }

        @Override
        public void gc(List<Long> timeStamps, List<Integer> indexes) throws RemoteException {
            int size = timeStamps.size();
            for (int i = 0; i < size; ++i) {
                CALLBACK_MANAGER.removeCallback(timeStamps.get(i), indexes.get(i));
            }
        }
    };

    private Channel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Channel getInstance() {
        if (sInstance != null) return sInstance;
        Class<Channel> clazz = Channel.class;
        synchronized (Channel.class) {
            if (sInstance != null) return sInstance;
            sInstance = new Channel();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(Context context, String packageName, Class<? extends HermesService> service) {
        Intent intent;
        HermesServiceConnection connection;
        Channel channel = this;
        synchronized (channel) {
            if (this.getBound(service)) {
                return;
            }
            Boolean binding = this.mBindings.get(service);
            if (binding != null && binding.booleanValue()) {
                return;
            }
            this.mBindings.put(service, true);
            connection = new HermesServiceConnection(service);
            this.mHermesServiceConnections.put(service, connection);
        }
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            intent = new Intent(context, service);
        } else {
            intent = new Intent();
            intent.setClassName(packageName, service.getName());
        }
        context.bindService(intent, (ServiceConnection)connection, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(Context context, Class<? extends HermesService> service) {
        Channel channel = this;
        synchronized (channel) {
            Boolean bound = this.mBounds.get(service);
            if (bound != null && bound.booleanValue()) {
                HermesServiceConnection connection = this.mHermesServiceConnections.get(service);
                if (connection != null) {
                    context.unbindService((ServiceConnection)connection);
                }
                this.mBounds.put(service, false);
            }
        }
    }

    public Reply send(Class<? extends HermesService> service, Mail mail) {
        IHermesService hermesService = this.mHermesServices.get(service);
        try {
            if (hermesService == null) {
                return new Reply(2, "Service Unavailable: Check whether you have connected Hermes.");
            }
            return hermesService.send(mail);
        }
        catch (RemoteException e) {
            return new Reply(1, "Remote Exception: Check whether the process you are communicating with is still alive.");
        }
    }

    public void gc(Class<? extends HermesService> service, List<Long> timeStamps) {
        IHermesService hermesService = this.mHermesServices.get(service);
        if (hermesService == null) {
            Log.e((String)TAG, (String)"Service Unavailable: Check whether you have disconnected the service before a process dies.");
        } else {
            try {
                hermesService.gc(timeStamps);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getBound(Class<? extends HermesService> service) {
        Boolean bound = this.mBounds.get(service);
        return bound != null && bound != false;
    }

    public void setHermesListener(HermesListener listener) {
        this.mListener = listener;
    }

    public boolean isConnected(Class<? extends HermesService> service) {
        IHermesService hermesService = this.mHermesServices.get(service);
        return hermesService != null && hermesService.asBinder().pingBinder();
    }

    private class HermesServiceConnection
    implements ServiceConnection {
        private Class<? extends HermesService> mClass;

        HermesServiceConnection(Class<? extends HermesService> service) {
            this.mClass = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder service) {
            Channel channel = Channel.this;
            synchronized (channel) {
                Channel.this.mBounds.put(this.mClass, true);
                Channel.this.mBindings.put(this.mClass, false);
                IHermesService hermesService = IHermesService.Stub.asInterface(service);
                Channel.this.mHermesServices.put(this.mClass, hermesService);
                try {
                    hermesService.register(Channel.this.mHermesServiceCallback, Process.myPid());
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    Log.e((String)Channel.TAG, (String)"Remote Exception: Check whether the process you are communicating with is still alive.");
                    return;
                }
            }
            if (Channel.this.mListener != null) {
                Channel.this.mListener.onHermesConnected(this.mClass);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName className) {
            Channel channel = Channel.this;
            synchronized (channel) {
                Channel.this.mHermesServices.remove(this.mClass);
                Channel.this.mBounds.put(this.mClass, false);
                Channel.this.mBindings.put(this.mClass, false);
            }
            if (Channel.this.mListener != null) {
                Channel.this.mListener.onHermesDisconnected(this.mClass);
            }
        }
    }
}

