/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.ipcapi;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import com.unionyy.ipcapi.internal.IHermesService;
import com.unionyy.ipcapi.internal.IHermesServiceCallback;
import com.unionyy.ipcapi.internal.Mail;
import com.unionyy.ipcapi.internal.Reply;
import com.unionyy.ipcapi.receiver.Receiver;
import com.unionyy.ipcapi.receiver.ReceiverDesignator;
import com.unionyy.ipcapi.util.HermesException;
import com.unionyy.ipcapi.util.ObjectCenter;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public abstract class HermesService
extends Service {
    private static final ObjectCenter OBJECT_CENTER = ObjectCenter.getInstance();
    private ConcurrentHashMap<Integer, IHermesServiceCallback> mCallbacks = new ConcurrentHashMap();
    private final IHermesService.Stub mBinder = new IHermesService.Stub(){

        @Override
        public Reply send(Mail mail) {
            try {
                Receiver receiver = ReceiverDesignator.getReceiver(mail.getObject());
                int pid = mail.getPid();
                IHermesServiceCallback callback = (IHermesServiceCallback)HermesService.this.mCallbacks.get(pid);
                if (callback != null) {
                    receiver.setHermesServiceCallback(callback);
                }
                return receiver.action(mail.getTimeStamp(), mail.getMethod(), mail.getParameters());
            }
            catch (HermesException e) {
                e.printStackTrace();
                return new Reply(e.getErrorCode(), e.getErrorMessage());
            }
        }

        @Override
        public void register(IHermesServiceCallback callback, int pid) throws RemoteException {
            HermesService.this.mCallbacks.put(pid, callback);
        }

        @Override
        public void gc(List<Long> timeStamps) throws RemoteException {
            OBJECT_CENTER.deleteObjects(timeStamps);
        }
    };

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public static class HermesService9
    extends HermesService {
    }

    public static class HermesService8
    extends HermesService {
    }

    public static class HermesService7
    extends HermesService {
    }

    public static class HermesService6
    extends HermesService {
    }

    public static class HermesService5
    extends HermesService {
    }

    public static class HermesService4
    extends HermesService {
    }

    public static class HermesService3
    extends HermesService {
    }

    public static class HermesService2
    extends HermesService {
    }

    public static class HermesService1
    extends HermesService {
    }

    public static class HermesService0
    extends HermesService {
    }
}

