/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.heytap.gift.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.yy.mobile.base.utils.DensityUtils;
import com.yy.mobile.memoryrecycle.views.YYRelativeLayout;

public class HeyTapRoundRectLayout
extends YYRelativeLayout {
    private Path mPath;
    private int mRadius;
    private int mWidth;
    private int mHeight;
    private int mLastRadius;
    public static final int MODE_NONE = 0;
    public static final int MODE_ALL = 1;
    public static final int MODE_LEFT = 2;
    public static final int MODE_TOP = 3;
    public static final int MODE_RIGHT = 4;
    public static final int MODE_BOTTOM = 5;
    private int mRoundMode = 1;

    public HeyTapRoundRectLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public HeyTapRoundRectLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mPath = new Path();
        this.mPath.setFillType(Path.FillType.EVEN_ODD);
        this.setCornerRadius(DensityUtils.dp2px((float)7.0f));
    }

    public void setRoundMode(int roundMode) {
        this.mRoundMode = roundMode;
    }

    public void setCornerRadius(int radius) {
        this.mRadius = radius;
    }

    private void checkPathChanged() {
        if (this.getWidth() == this.mWidth && this.getHeight() == this.mHeight && this.mLastRadius == this.mRadius) {
            return;
        }
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        this.mLastRadius = this.mRadius;
        this.mPath.reset();
        switch (this.mRoundMode) {
            case 1: {
                this.mPath.addRoundRect(new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight), (float)this.mRadius, (float)this.mRadius, Path.Direction.CW);
                break;
            }
            case 2: {
                this.mPath.addRoundRect(new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight), new float[]{this.mRadius, this.mRadius, 0.0f, 0.0f, 0.0f, 0.0f, this.mRadius, this.mRadius}, Path.Direction.CW);
                break;
            }
            case 3: {
                this.mPath.addRoundRect(new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight), new float[]{this.mRadius, this.mRadius, this.mRadius, this.mRadius, 0.0f, 0.0f, 0.0f, 0.0f}, Path.Direction.CW);
                break;
            }
            case 4: {
                this.mPath.addRoundRect(new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight), new float[]{0.0f, 0.0f, this.mRadius, this.mRadius, this.mRadius, this.mRadius, 0.0f, 0.0f}, Path.Direction.CW);
                break;
            }
            case 5: {
                this.mPath.addRoundRect(new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight), new float[]{0.0f, 0.0f, 0.0f, 0.0f, this.mRadius, this.mRadius, this.mRadius, this.mRadius}, Path.Direction.CW);
                break;
            }
        }
    }

    public void draw(Canvas canvas) {
        if (this.mRoundMode != 0) {
            int saveCount = canvas.save();
            this.checkPathChanged();
            canvas.clipPath(this.mPath);
            super.draw(canvas);
            canvas.restoreToCount(saveCount);
        } else {
            super.draw(canvas);
        }
    }
}

