/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.heytap.gift;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.unionyy.mobile.heytap.R;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.gift.GiftConfigParser;
import com.yymobile.core.gift.config.bean.AmountInfo;
import com.yymobile.core.gift.config.bean.GiftConfigBean;
import java.util.ArrayList;
import java.util.List;

public class OPGiftAmountListAdapter
extends BaseAdapter {
    public static final String TAG = "OPGiftAmountListAdapter";
    private static final int MAXGRAD = 8;
    private static final int MINIGRAD = 1;
    public static final int FREEGIFTGRADE = 100;
    public static final int FIXEDGRADE = 101;
    private static final String LAST_SELECTED_GIFT_AMOUNT = "gift_last_amount";
    private final List<AmountInfo> amoutInfoList;
    private final List<AmountInfo> bowAmoutInfoList;
    protected Context mContext;
    protected LayoutInflater mInflater;
    protected int mCurrentAmount;
    private int mSelecedGiftGrade = 1;
    private List<AmountInfo> mSelectedGiftAmountInfos = new ArrayList<AmountInfo>();

    public OPGiftAmountListAdapter(final Context context) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.amoutInfoList = new ArrayList<AmountInfo>(){
            {
                this.add(new AmountInfo(1314, context.getString(R.string.str_gift_amount_1314)));
                this.add(new AmountInfo(520, context.getString(R.string.str_gift_amount_520)));
                this.add(new AmountInfo(188, context.getString(R.string.str_gift_amount_188)));
                this.add(new AmountInfo(66, context.getString(R.string.str_gift_amount_66)));
                this.add(new AmountInfo(30, context.getString(R.string.str_gift_amount_30)));
                this.add(new AmountInfo(10, context.getString(R.string.str_gift_amount_10)));
                this.add(new AmountInfo(1, context.getString(R.string.str_gift_amount_1)));
            }
        };
        this.bowAmoutInfoList = new ArrayList<AmountInfo>(){
            {
                this.add(new AmountInfo(1, context.getString(R.string.str_gift_amount_1)));
            }
        };
        this.mSelectedGiftAmountInfos.addAll(this.amoutInfoList);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        AmountItemViewHolder viewHolder;
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.op_gift_link_amount_list_item, parent, false);
            viewHolder = new AmountItemViewHolder();
            viewHolder.amountTextView = (TextView)convertView.findViewById(R.id.tv_amount);
            viewHolder.descriptionTextView = (TextView)convertView.findViewById(R.id.tv_description);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (AmountItemViewHolder)convertView.getTag();
        }
        Object itemObject = this.getItem(position);
        if (itemObject != null) {
            AmountInfo amountInfo = (AmountInfo)itemObject;
            viewHolder.descriptionTextView.setText((CharSequence)amountInfo.description);
            if (amountInfo.amount == -1) {
                viewHolder.amountTextView.setVisibility(8);
                viewHolder.amountTextView.setText((CharSequence)"");
                viewHolder.descriptionTextView.setTextColor(this.mContext.getResources().getColor(R.color.white));
                viewHolder.descriptionTextView.setGravity(17);
                viewHolder.descriptionTextView.setTextSize(0, (float)this.mContext.getResources().getDimensionPixelSize(R.dimen.long_text_tips_fnt));
            } else {
                viewHolder.amountTextView.setVisibility(0);
                viewHolder.amountTextView.setText((CharSequence)String.valueOf(amountInfo.amount));
                viewHolder.descriptionTextView.setGravity(3);
                viewHolder.descriptionTextView.setTextSize(0, (float)this.mContext.getResources().getDimensionPixelSize(R.dimen.short_text_navigation_fnt));
            }
            if (amountInfo.amount == this.mCurrentAmount) {
                if (position == 0) {
                    convertView.setBackground(this.mContext.getResources().getDrawable(R.drawable.op_gift_number_select_bg_top));
                } else if (position == this.mSelectedGiftAmountInfos.size() - 1) {
                    convertView.setBackground(this.mContext.getResources().getDrawable(R.drawable.op_gift_number_select_bg_bottom));
                } else {
                    convertView.setBackgroundResource(R.color.op_gift_amount_selected_color);
                }
                viewHolder.descriptionTextView.setTextColor(this.mContext.getResources().getColor(R.color.op_gift_white_p40));
            } else {
                convertView.setBackgroundResource(R.color.transparent);
                if (amountInfo.amount == -1) {
                    viewHolder.descriptionTextView.setTextColor(this.mContext.getResources().getColor(R.color.op_gift_white_p40));
                } else {
                    viewHolder.descriptionTextView.setTextColor(this.mContext.getResources().getColor(R.color.op_gift_white_p40));
                }
            }
        }
        return convertView;
    }

    public int getCount() {
        return this.mSelectedGiftAmountInfos.size();
    }

    public void setCantSelectGiftAmount() {
        ArrayList<AmountInfo> amountInfos = new ArrayList<AmountInfo>();
        amountInfos.addAll(this.bowAmoutInfoList);
        this.mSelectedGiftAmountInfos = amountInfos;
        if (this.mSelectedGiftAmountInfos.size() > 1) {
            int maxAmount = this.mSelectedGiftAmountInfos.get((int)0).amount;
            if (this.mCurrentAmount > maxAmount) {
                this.mCurrentAmount = maxAmount;
            }
            this.notifyDataSetChanged();
        }
    }

    public boolean setCurrentPaidGiftAmount(int grade, int giftId, boolean isBig) {
        if (grade < 1) {
            grade = 1;
        } else if (grade > 8) {
            grade = 8;
        }
        ArrayList<AmountInfo> amountInfos = GiftConfigParser.getInstance().getGiftAmountList(giftId);
        GiftConfigBean bean = GiftConfigParser.getInstance().getGiftConfigBeanById(giftId);
        if (bean != null && bean.business == 17) {
            this.setCantSelectGiftAmount();
            return true;
        }
        if (amountInfos == null || amountInfos.size() == 0) {
            if (isBig) {
                this.setCantSelectGiftAmount();
                return true;
            }
            amountInfos = new ArrayList<AmountInfo>();
            amountInfos.addAll(this.amoutInfoList);
            switch (grade) {
                case 8: {
                    amountInfos.remove(1);
                }
                case 7: {
                    amountInfos.remove(1);
                }
                case 6: {
                    amountInfos.remove(1);
                }
                case 5: {
                    amountInfos.remove(1);
                }
                case 4: {
                    amountInfos.remove(1);
                    break;
                }
            }
        }
        this.mSelectedGiftAmountInfos = amountInfos;
        this.mSelecedGiftGrade = grade;
        if (this.mSelectedGiftAmountInfos.size() > 1) {
            int maxAmount = this.mSelectedGiftAmountInfos.get((int)0).amount;
            if (this.mCurrentAmount > maxAmount) {
                this.mCurrentAmount = maxAmount;
            }
            this.notifyDataSetChanged();
        }
        return this.mSelectedGiftAmountInfos.size() <= 1;
    }

    public boolean setCurrentFreeGiftAmount(int num, int grade, int giftId, GiftConfigParser.FreeGiftConfigItem.Business business, boolean isPrePaid) {
        List amountInfos = GiftConfigParser.getInstance().getGiftAmountList(giftId);
        if (amountInfos != null && amountInfos.size() > 0) {
            if (business == GiftConfigParser.FreeGiftConfigItem.Business.first_charge || business == GiftConfigParser.FreeGiftConfigItem.Business.first_send) {
                this.setCurrentGiftAmountFixed(((AmountInfo)amountInfos.get((int)0)).amount);
                return true;
            }
            this.mSelectedGiftAmountInfos = amountInfos;
            this.mSelecedGiftGrade = grade;
            if (this.mSelectedGiftAmountInfos.size() > 1) {
                int maxAmount = this.mSelectedGiftAmountInfos.get((int)0).amount;
                if (this.mCurrentAmount > maxAmount) {
                    this.mCurrentAmount = maxAmount;
                }
                this.notifyDataSetChanged();
            }
            return this.mSelectedGiftAmountInfos.size() <= 1;
        }
        if (business == GiftConfigParser.FreeGiftConfigItem.Business.first_charge || business == GiftConfigParser.FreeGiftConfigItem.Business.first_send) {
            this.setCurrentGiftAmountFixed(66);
            return true;
        }
        if (num < 10) {
            this.setCantSelectGiftAmount();
            return true;
        }
        if (isPrePaid) {
            return this.setCurrentPrePaidGiftGrade(num, grade);
        }
        this.setCurrentFreeGiftGrade(num);
        return false;
    }

    private void setCurrentGiftAmountFixed(int num) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"setCurrentFreeGiftAmountFixed num=%d", (Object[])new Object[]{num});
        }
        this.mSelecedGiftGrade = 101;
        this.mCurrentAmount = num;
    }

    private boolean setCurrentPrePaidGiftGrade(int num, int grade) {
        ArrayList<AmountInfo> amountInfos = new ArrayList<AmountInfo>();
        amountInfos.addAll(this.amoutInfoList);
        if (grade < 1) {
            grade = 1;
        } else if (grade > 8) {
            grade = 8;
        }
        switch (grade) {
            case 8: {
                amountInfos.remove(1);
            }
            case 7: {
                amountInfos.remove(1);
            }
            case 6: {
                amountInfos.remove(1);
            }
            case 5: {
                amountInfos.remove(1);
            }
            case 4: {
                amountInfos.remove(1);
                break;
            }
        }
        this.mSelectedGiftAmountInfos = amountInfos;
        this.mSelecedGiftGrade = grade;
        if (this.mSelectedGiftAmountInfos.size() > 1) {
            int maxAmount = this.mSelectedGiftAmountInfos.get((int)0).amount;
            if (this.mCurrentAmount > maxAmount) {
                this.mCurrentAmount = maxAmount;
            }
            if (this.mCurrentAmount > num) {
                this.mCurrentAmount = num;
            }
            this.notifyDataSetChanged();
        }
        return this.mSelectedGiftAmountInfos.size() <= 1;
    }

    private void setCurrentFreeGiftGrade(int num) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"setCurrentFreeGiftGrade num=%d", (Object[])new Object[]{num});
        }
        ArrayList<AmountInfo> amountInfos = new ArrayList<AmountInfo>();
        if (num < 30) {
            amountInfos.add(new AmountInfo(10, this.mContext.getString(R.string.str_gift_amount_10)));
            amountInfos.add(new AmountInfo(1, this.mContext.getString(R.string.str_gift_amount_1)));
        } else if (num >= 30 && num < 66) {
            amountInfos.add(new AmountInfo(30, this.mContext.getString(R.string.str_gift_amount_30)));
            amountInfos.add(new AmountInfo(10, this.mContext.getString(R.string.str_gift_amount_10)));
            amountInfos.add(new AmountInfo(1, this.mContext.getString(R.string.str_gift_amount_1)));
        } else if (num >= 66 && num < 188) {
            amountInfos.add(new AmountInfo(66, this.mContext.getString(R.string.str_gift_amount_66)));
            amountInfos.add(new AmountInfo(30, this.mContext.getString(R.string.str_gift_amount_30)));
            amountInfos.add(new AmountInfo(10, this.mContext.getString(R.string.str_gift_amount_10)));
            amountInfos.add(new AmountInfo(1, this.mContext.getString(R.string.str_gift_amount_1)));
        } else if (num >= 188 && num < 520) {
            amountInfos.add(new AmountInfo(188, this.mContext.getString(R.string.str_gift_amount_188)));
            amountInfos.add(new AmountInfo(66, this.mContext.getString(R.string.str_gift_amount_66)));
            amountInfos.add(new AmountInfo(30, this.mContext.getString(R.string.str_gift_amount_30)));
            amountInfos.add(new AmountInfo(10, this.mContext.getString(R.string.str_gift_amount_10)));
            amountInfos.add(new AmountInfo(1, this.mContext.getString(R.string.str_gift_amount_1)));
        } else if (num >= 520 && num < 1314) {
            amountInfos.add(new AmountInfo(520, this.mContext.getString(R.string.str_gift_amount_520)));
            amountInfos.add(new AmountInfo(188, this.mContext.getString(R.string.str_gift_amount_188)));
            amountInfos.add(new AmountInfo(66, this.mContext.getString(R.string.str_gift_amount_66)));
            amountInfos.add(new AmountInfo(30, this.mContext.getString(R.string.str_gift_amount_30)));
            amountInfos.add(new AmountInfo(10, this.mContext.getString(R.string.str_gift_amount_10)));
            amountInfos.add(new AmountInfo(1, this.mContext.getString(R.string.str_gift_amount_1)));
        } else if (num >= 1314) {
            amountInfos.addAll(this.amoutInfoList);
        }
        this.mSelectedGiftAmountInfos = amountInfos;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("mSelectedGiftAmountInfos " + this.mSelectedGiftAmountInfos), (Object[])new Object[0]);
        }
        this.mSelecedGiftGrade = 100;
        if (this.mSelectedGiftAmountInfos != null && this.mSelectedGiftAmountInfos.size() > 1) {
            int maxAmount = this.mSelectedGiftAmountInfos.get((int)0).amount;
            if (this.mCurrentAmount > maxAmount) {
                this.mCurrentAmount = maxAmount;
            }
            this.notifyDataSetChanged();
        }
    }

    public Object getItem(int position) {
        if (position >= 0 && position < this.mSelectedGiftAmountInfos.size()) {
            return this.mSelectedGiftAmountInfos.get(position);
        }
        return null;
    }

    public Integer getAmount(int position) {
        AmountInfo amountInfo = (AmountInfo)this.getItem(position);
        if (amountInfo != null) {
            return amountInfo.amount;
        }
        return 0;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public int getCurrentAmount() {
        int maxAmount;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"getCurrentAmount mCurrentAmount, %d", (Object[])new Object[]{this.mCurrentAmount});
        }
        if (this.mSelecedGiftGrade == 100) {
            return this.mCurrentAmount;
        }
        if (this.mSelecedGiftGrade == 101) {
            return this.mCurrentAmount;
        }
        if (this.mCurrentAmount <= 1) {
            this.mCurrentAmount = CommonPref.instance().getInt(LAST_SELECTED_GIFT_AMOUNT, 1);
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"getCurrentAmount mSaveAmount, %d", (Object[])new Object[]{CommonPref.instance().getInt(LAST_SELECTED_GIFT_AMOUNT, 1)});
        }
        if ((maxAmount = this.getAmount(0).intValue()) < this.mCurrentAmount) {
            return maxAmount;
        }
        return this.mCurrentAmount == 0 ? 1 : this.mCurrentAmount;
    }

    public void setCurrentAmount(int amount) {
        this.mCurrentAmount = amount;
        this.notifyDataSetChanged();
        CommonPref.instance().putInt(LAST_SELECTED_GIFT_AMOUNT, amount);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"mCurrentAmount", (String)"mCurrentAmount, %d", (Object[])new Object[]{this.mCurrentAmount});
        }
    }

    public static class AmountItemViewHolder {
        public TextView amountTextView;
        public TextView descriptionTextView;
    }
}

