/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.yyprotocol.core;

import android.annotation.SuppressLint;
import com.yy.mobile.yyprotocol.core.Int64;
import com.yy.mobile.yyprotocol.core.Uint16;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yy.mobile.yyprotocol.core.Uint64;
import com.yy.mobile.yyprotocol.core.Uint8;
import com.yy.mobile.yyprotocol.core.UnpackException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Unpack {
    protected ByteBuffer buffer;

    public Unpack(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public Unpack(byte[] bytes, int offset, int length) {
        this.buffer = ByteBuffer.wrap(bytes, offset, length);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public int size() {
        return this.buffer.remaining();
    }

    public Uint32 popUint32() {
        return new Uint32(this.buffer.getInt());
    }

    public int popInt() {
        return this.buffer.getInt();
    }

    public long popLong() {
        return this.buffer.getLong();
    }

    public Uint8 popUint8() {
        return new Uint8(this.buffer.get());
    }

    public Uint16 popUint16() {
        return new Uint16(this.buffer.getShort());
    }

    public Int64 popInt64() {
        return new Int64(this.buffer.getLong());
    }

    public Uint64 popUint64() {
        return new Uint64(this.buffer.getLong());
    }

    public boolean popBoolean() {
        return this.buffer.get() == 1;
    }

    public byte[] popBytes() {
        short size = this.buffer.getShort();
        byte[] dst = new byte[this.toUnsigned(size)];
        this.buffer.get(dst);
        return dst;
    }

    public int toUnsigned(short s) {
        return s & 0xFFFF;
    }

    public String popString() {
        try {
            byte[] dst = this.popBytes();
            return new String(dst, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnpackException();
        }
    }

    public String popString(String encoding) {
        try {
            byte[] dst = this.popBytes();
            return new String(dst, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnpackException();
        }
    }

    public String popString32() {
        try {
            int size = this.buffer.getInt();
            byte[] dst = new byte[size];
            this.buffer.get(dst);
            return new String(dst, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnpackException();
        }
    }

    public byte[] popBytes32() {
        int size = this.buffer.getInt();
        byte[] dst = new byte[size];
        this.buffer.get(dst);
        return dst;
    }

    public byte[] popBytesUint32() {
        int remaining;
        int size = this.buffer.getInt();
        if (size <= (remaining = this.buffer.remaining())) {
            byte[] dst = new byte[size];
            this.buffer.get(dst);
            return dst;
        }
        throw new UnpackException("size=" + size + ",but remaining=" + remaining);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Pack [buffer=");
        builder.append(this.bufferString());
        builder.append("]");
        return builder.toString();
    }

    @SuppressLint(value={"DefaultLocale"})
    private String bufferString() {
        byte[] b = new byte[this.buffer.remaining()];
        int oldPosition = this.buffer.position();
        this.buffer.get(b);
        this.buffer.position(oldPosition);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            sb.append(Integer.toHexString(b[i] & 0xFF).toUpperCase()).append(" ");
        }
        return sb.toString();
    }
}

