/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.menudrawer;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import com.yy.mobile.ui.widget.menudrawer.MenuDrawer;
import com.yy.mobile.ui.widget.menudrawer.PeekInterpolator;
import com.yy.mobile.ui.widget.menudrawer.Scroller;
import com.yy.mobile.ui.widget.menudrawer.ViewHelper;

public abstract class DraggableDrawer
extends MenuDrawer {
    private static final String STATE_MENU_VISIBLE = "net.simonvt.menudrawer.MenuDrawer.menuVisible";
    private static final Interpolator PEEK_INTERPOLATOR = new PeekInterpolator();
    protected static final int MAX_MENU_OVERLAY_ALPHA = 185;
    private static final long DEFAULT_PEEK_START_DELAY = 5000L;
    private static final long DEFAULT_PEEK_DELAY = 10000L;
    protected static final int PEEK_DURATION = 5000;
    private static final int CLOSE_ENOUGH = 3;
    protected static final int INVALID_POINTER = -1;
    protected int mTouchSlop;
    protected final Runnable mPeekRunnable = new Runnable(){

        @Override
        public void run() {
            DraggableDrawer.this.peekDrawerInvalidate();
        }
    };
    private final Runnable mDragRunnable = new Runnable(){

        @Override
        public void run() {
            DraggableDrawer.this.postAnimationInvalidate();
        }
    };
    protected boolean mIsDragging;
    protected int mActivePointerId = -1;
    protected float mInitialMotionX;
    protected float mInitialMotionY;
    protected float mLastMotionX = -1.0f;
    protected float mLastMotionY = -1.0f;
    protected long mPeekDelay;
    protected Scroller mPeekScroller;
    protected VelocityTracker mVelocityTracker;
    protected int mMaxVelocity;
    protected boolean mOffsetMenu = true;
    protected int mCloseEnough;
    private Runnable mPeekStartRunnable;
    protected boolean mIsPeeking;
    private Scroller mScroller;
    protected boolean mLayerTypeHardware;

    DraggableDrawer(Activity activity, int dragMode) {
        super(activity, dragMode);
    }

    public DraggableDrawer(Context context) {
        super(context);
    }

    public DraggableDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public DraggableDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void initDrawer(Context context, AttributeSet attrs, int defStyle) {
        super.initDrawer(context, attrs, defStyle);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMaxVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mScroller = new Scroller(context, MenuDrawer.SMOOTH_INTERPOLATOR);
        this.mPeekScroller = new Scroller(context, PEEK_INTERPOLATOR);
        this.mCloseEnough = this.dpToPx(3);
    }

    @Override
    public void toggleMenu(boolean animate) {
        if (this.mDrawerState == 8 || this.mDrawerState == 4) {
            this.closeMenu(animate);
        } else if (this.mDrawerState == 0 || this.mDrawerState == 1) {
            this.openMenu(animate);
        }
    }

    @Override
    public boolean isMenuVisible() {
        return this.mMenuVisible;
    }

    @Override
    public void setMenuSize(int size) {
        this.mMenuSize = size;
        if (this.mDrawerState == 8 || this.mDrawerState == 4) {
            this.setOffsetPixels(this.mMenuSize);
        }
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void setOffsetMenuEnabled(boolean offsetMenu) {
        if (offsetMenu != this.mOffsetMenu) {
            this.mOffsetMenu = offsetMenu;
            this.requestLayout();
            this.invalidate();
        }
    }

    @Override
    public boolean getOffsetMenuEnabled() {
        return this.mOffsetMenu;
    }

    @Override
    public void peekDrawer() {
        this.peekDrawer(5000L, 10000L);
    }

    @Override
    public void peekDrawer(long delay) {
        this.peekDrawer(5000L, delay);
    }

    @Override
    public void peekDrawer(long startDelay, long delay) {
        if (startDelay < 0L) {
            throw new IllegalArgumentException("startDelay must be zero or larger.");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException("delay must be zero or larger");
        }
        this.removeCallbacks(this.mPeekRunnable);
        this.removeCallbacks(this.mPeekStartRunnable);
        this.mPeekDelay = delay;
        this.mPeekStartRunnable = new Runnable(){

            @Override
            public void run() {
                DraggableDrawer.this.startPeek();
            }
        };
        this.postDelayed(this.mPeekStartRunnable, startDelay);
    }

    @Override
    public void setHardwareLayerEnabled(boolean enabled) {
        if (enabled != this.mHardwareLayersEnabled) {
            this.mHardwareLayersEnabled = enabled;
            this.mMenuContainer.setHardwareLayersEnabled(enabled);
            this.mContentContainer.setHardwareLayersEnabled(enabled);
            this.stopLayerTranslation();
        }
    }

    @Override
    public int getTouchMode() {
        return this.mTouchMode;
    }

    @Override
    public void setTouchMode(int mode) {
        if (this.mTouchMode != mode) {
            this.mTouchMode = mode;
            this.updateTouchAreaSize();
        }
    }

    @Override
    public void setTouchBezelSize(int size) {
        this.mTouchBezelSize = size;
    }

    @Override
    public int getTouchBezelSize() {
        return this.mTouchBezelSize;
    }

    protected void startLayerTranslation() {
        if (USE_TRANSLATIONS && this.mHardwareLayersEnabled && !this.mLayerTypeHardware) {
            this.mLayerTypeHardware = true;
            this.mContentContainer.setLayerType(2, null);
            this.mMenuContainer.setLayerType(2, null);
        }
    }

    protected void stopLayerTranslation() {
        if (this.mLayerTypeHardware) {
            this.mLayerTypeHardware = false;
            this.mContentContainer.setLayerType(0, null);
            this.mMenuContainer.setLayerType(0, null);
        }
    }

    protected void endDrag() {
        this.mIsDragging = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    protected void stopAnimation() {
        this.removeCallbacks(this.mDragRunnable);
        this.mScroller.abortAnimation();
        this.stopLayerTranslation();
    }

    private void completeAnimation() {
        this.mScroller.abortAnimation();
        int finalX = this.mScroller.getFinalX();
        this.setOffsetPixels(finalX);
        this.setDrawerState(finalX == 0 ? 0 : 8);
        this.stopLayerTranslation();
    }

    protected void cancelContentTouch() {
        long now = SystemClock.uptimeMillis();
        MotionEvent cancelEvent = MotionEvent.obtain((long)now, (long)now, (int)3, (float)0.0f, (float)0.0f, (int)0);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.getChildAt(i).dispatchTouchEvent(cancelEvent);
        }
        this.mContentContainer.dispatchTouchEvent(cancelEvent);
        cancelEvent.recycle();
    }

    protected void animateOffsetTo(int position, int velocity, boolean animate) {
        this.endDrag();
        this.endPeek();
        int startX = (int)this.mOffsetPixels;
        int dx = position - startX;
        if (dx == 0 || !animate) {
            this.setOffsetPixels(position);
            this.setDrawerState(position == 0 ? 0 : 8);
            this.stopLayerTranslation();
            return;
        }
        int duration = (velocity = Math.abs(velocity)) > 0 ? 4 * Math.round(1000.0f * Math.abs((float)dx / (float)velocity)) : (int)(600.0f * Math.abs((float)dx / (float)this.mMenuSize));
        duration = Math.min(duration, this.mMaxAnimationDuration);
        this.animateOffsetTo(position, duration);
    }

    protected void animateOffsetTo(int position, int duration) {
        int startX = (int)this.mOffsetPixels;
        int dx = position - startX;
        if (dx > 0) {
            this.setDrawerState(4);
            this.mScroller.startScroll(startX, 0, dx, 0, duration);
        } else {
            this.setDrawerState(1);
            this.mScroller.startScroll(startX, 0, dx, 0, duration);
        }
        this.startLayerTranslation();
        this.postAnimationInvalidate();
    }

    private void postAnimationInvalidate() {
        if (this.mScroller.computeScrollOffset()) {
            int oldX = (int)this.mOffsetPixels;
            int x = this.mScroller.getCurrX();
            if (x != oldX) {
                this.setOffsetPixels(x);
            }
            if (x != this.mScroller.getFinalX()) {
                this.postOnAnimation(this.mDragRunnable);
                return;
            }
        }
        this.completeAnimation();
    }

    protected void startPeek() {
        this.mIsPeeking = true;
        this.initPeekScroller();
        this.startLayerTranslation();
        this.peekDrawerInvalidate();
    }

    protected abstract void initPeekScroller();

    private void peekDrawerInvalidate() {
        if (this.mPeekScroller.computeScrollOffset()) {
            int oldX = (int)this.mOffsetPixels;
            int x = this.mPeekScroller.getCurrX();
            if (x != oldX) {
                this.setOffsetPixels(x);
            }
            if (!this.mPeekScroller.isFinished()) {
                this.postOnAnimation(this.mPeekRunnable);
                return;
            }
            if (this.mPeekDelay > 0L) {
                this.mPeekStartRunnable = new Runnable(){

                    @Override
                    public void run() {
                        DraggableDrawer.this.startPeek();
                    }
                };
                this.postDelayed(this.mPeekStartRunnable, this.mPeekDelay);
            }
        }
        this.completePeek();
    }

    private void completePeek() {
        this.mPeekScroller.abortAnimation();
        this.setOffsetPixels(0.0f);
        this.setDrawerState(0);
        this.stopLayerTranslation();
        this.mIsPeeking = false;
    }

    protected void endPeek() {
        this.removeCallbacks(this.mPeekStartRunnable);
        this.removeCallbacks(this.mPeekRunnable);
        this.stopLayerTranslation();
        this.mIsPeeking = false;
    }

    protected boolean isCloseEnough() {
        return Math.abs(this.mOffsetPixels) <= (float)this.mCloseEnough;
    }

    protected boolean canChildrenScroll(int dx, int dy, int x, int y) {
        boolean canScroll = false;
        switch (this.getPosition()) {
            case LEFT: 
            case RIGHT: {
                if (!this.mMenuVisible) {
                    canScroll = this.canChildScrollHorizontally((View)this.mContentContainer, false, dx, x - ViewHelper.getLeft((View)this.mContentContainer), y - ViewHelper.getTop((View)this.mContentContainer));
                    break;
                }
                canScroll = this.canChildScrollHorizontally((View)this.mMenuContainer, false, dx, x - ViewHelper.getLeft((View)this.mMenuContainer), y - ViewHelper.getTop((View)this.mContentContainer));
                break;
            }
            case TOP: 
            case BOTTOM: {
                canScroll = !this.mMenuVisible ? this.canChildScrollVertically((View)this.mContentContainer, false, dy, x - ViewHelper.getLeft((View)this.mContentContainer), y - ViewHelper.getTop((View)this.mContentContainer)) : this.canChildScrollVertically((View)this.mMenuContainer, false, dy, x - ViewHelper.getLeft((View)this.mMenuContainer), y - ViewHelper.getTop((View)this.mContentContainer));
            }
        }
        return canScroll;
    }

    protected boolean canChildScrollHorizontally(View v, boolean checkV, int dx, int x, int y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                int childLeft = child.getLeft() + this.supportGetTranslationX(child);
                int childRight = child.getRight() + this.supportGetTranslationX(child);
                int childTop = child.getTop() + this.supportGetTranslationY(child);
                int childBottom = child.getBottom() + this.supportGetTranslationY(child);
                if (x < childLeft || x >= childRight || y < childTop || y >= childBottom || !this.canChildScrollHorizontally(child, true, dx, x - childLeft, y - childTop)) continue;
                return true;
            }
        }
        return checkV && this.mOnInterceptMoveEventListener.isViewDraggable(v, dx, x, y);
    }

    protected boolean canChildScrollVertically(View v, boolean checkV, int dx, int x, int y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                int childLeft = child.getLeft() + this.supportGetTranslationX(child);
                int childRight = child.getRight() + this.supportGetTranslationX(child);
                int childTop = child.getTop() + this.supportGetTranslationY(child);
                int childBottom = child.getBottom() + this.supportGetTranslationY(child);
                if (x < childLeft || x >= childRight || y < childTop || y >= childBottom || !this.canChildScrollVertically(child, true, dx, x - childLeft, y - childTop)) continue;
                return true;
            }
        }
        return checkV && this.mOnInterceptMoveEventListener.isViewDraggable(v, dx, x, y);
    }

    protected float getXVelocity(VelocityTracker velocityTracker) {
        if (Build.VERSION.SDK_INT >= 8) {
            return velocityTracker.getXVelocity(this.mActivePointerId);
        }
        return velocityTracker.getXVelocity();
    }

    protected float getYVelocity(VelocityTracker velocityTracker) {
        if (Build.VERSION.SDK_INT >= 8) {
            return velocityTracker.getYVelocity(this.mActivePointerId);
        }
        return velocityTracker.getYVelocity();
    }

    private int supportGetTranslationY(View v) {
        if (Build.VERSION.SDK_INT >= 11) {
            return (int)v.getTranslationY();
        }
        return 0;
    }

    private int supportGetTranslationX(View v) {
        if (Build.VERSION.SDK_INT >= 11) {
            return (int)v.getTranslationX();
        }
        return 0;
    }

    @Override
    void saveState(Bundle state) {
        boolean menuVisible = this.mDrawerState == 8 || this.mDrawerState == 4;
        state.putBoolean(STATE_MENU_VISIBLE, menuVisible);
    }

    @Override
    public void restoreState(Parcelable in) {
        super.restoreState(in);
        Bundle state = (Bundle)in;
        boolean menuOpen = state.getBoolean(STATE_MENU_VISIBLE);
        if (menuOpen) {
            this.openMenu(false);
        } else {
            this.setOffsetPixels(0.0f);
        }
        this.mDrawerState = menuOpen ? 8 : 0;
    }
}

