/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.rxbus;

import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import com.jakewharton.rxrelay2.Relay;
import com.yy.mobile.config.BasicConfig;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.operators.flowable.EventFlowableHelper;
import io.reactivex.internal.operators.observable.EventObservableHelper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class EventPublishRelay<T>
extends Relay<T> {
    private static final String TAG = "EventPublishRelay";
    private static final PublishDisposable[] EMPTY = new PublishDisposable[0];
    private final Map<Class<?>, AtomicReference<PublishDisposable<T>[]>> subscribers = new ConcurrentHashMap();

    public static <T> EventPublishRelay<T> create() {
        return new EventPublishRelay<T>();
    }

    private EventPublishRelay() {
    }

    public void subscribeActual(Observer<? super T> t) {
        PublishDisposable<T> ps = new PublishDisposable<T>(t, this);
        t.onSubscribe(ps);
        this.add(this.getEventClass(t), ps);
        if (ps.isDisposed()) {
            this.remove(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Class<?> cls, PublishDisposable<T> ps) {
        AtomicReference<PublishDisposable<T>[]> eventSubscribers = this.subscribers.get(cls);
        if (eventSubscribers == null) {
            Map<Class<?>, AtomicReference<PublishDisposable<T>[]>> map = this.subscribers;
            synchronized (map) {
                eventSubscribers = this.subscribers.get(cls);
                if (eventSubscribers == null) {
                    eventSubscribers = new AtomicReference<PublishDisposable[]>(EMPTY);
                    this.subscribers.put(cls, eventSubscribers);
                }
            }
        }
        this.add(eventSubscribers, ps);
    }

    private void add(AtomicReference<PublishDisposable<T>[]> eventSubscribers, PublishDisposable<T> ps) {
        PublishDisposable[] b;
        PublishDisposable<T>[] a;
        do {
            a = eventSubscribers.get();
            int n = a.length;
            b = new PublishDisposable[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = ps;
        } while (!eventSubscribers.compareAndSet(a, b));
    }

    void remove(PublishDisposable<T> ps) {
        this.remove(this.subscribers.get(this.getEventClass(ps.actual)), ps);
    }

    private void remove(AtomicReference<PublishDisposable<T>[]> eventSubscribers, PublishDisposable<T> ps) {
        PublishDisposable[] b;
        PublishDisposable<T>[] a;
        do {
            if (eventSubscribers == null) {
                return;
            }
            a = eventSubscribers.get();
            if (a == EMPTY) {
                return;
            }
            int n = a.length;
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != ps) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new PublishDisposable[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!eventSubscribers.compareAndSet(a, b));
    }

    public void accept(T value) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        AtomicReference<PublishDisposable<T>[]> eventSubscribers = this.subscribers.get(value.getClass());
        if (eventSubscribers != null) {
            boolean isMainThread = Looper.myLooper() == Looper.getMainLooper();
            StringBuilder builder = new StringBuilder();
            builder.append("\n");
            long t = 0L;
            boolean print = false;
            for (PublishDisposable<T> s : eventSubscribers.get()) {
                if (isMainThread) {
                    t = SystemClock.currentThreadTimeMillis();
                }
                s.onNext(value);
                if (!isMainThread || SystemClock.currentThreadTimeMillis() - t <= 80L) continue;
                builder.append(s.toString()).append("\n");
                print = true;
            }
            if (print && BasicConfig.getInstance().isDebuggable()) {
                Log.e((String)TAG, (String)(">80ms kale:" + builder.toString()));
            }
        }
    }

    public boolean hasObservers() {
        return this.subscribers.size() != 0;
    }

    public <T> Class<?> getEventClass(Observer<? super T> t) {
        Class<?> cls = EventObservableHelper.getEventClass(t);
        if (cls == null) {
            cls = EventFlowableHelper.getEventClass(t);
        }
        return cls;
    }

    static final class PublishDisposable<T>
    extends AtomicBoolean
    implements Disposable {
        private static final long serialVersionUID = 3562861878281475070L;
        final Observer<? super T> actual;
        final EventPublishRelay<T> parent;

        PublishDisposable(Observer<? super T> actual, EventPublishRelay<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        void onNext(T t) {
            if (!this.get()) {
                this.actual.onNext(t);
            }
        }

        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.parent.remove(this);
            }
        }

        public boolean isDisposed() {
            return this.get();
        }
    }
}

