/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext.media;

import com.yy.mobile.http.BaseNetwork;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.Request;
import com.yy.mobile.util.log.MLog;
import java.util.Map;
import okhttp3.Request;

public class ImSwitchUrlNetwork
extends BaseNetwork {
    public static final String DXIMSCREENSHOT = "dximscreenshot";
    public static final String WTIMSCREENSHOT = "wtimscreenshot";

    @Override
    protected okhttp3.Request createHttpRequest(Request<?> request, Map<String, String> additionalHeaders) {
        Request.Builder builder = new Request.Builder();
        String url = request.getUrl();
        switch (request.getMethod()) {
            case 0: {
                if (request.getRetryPolicy().getCurrentRetryCount() > 0) {
                    url = ImSwitchUrlNetwork.switchToBackupHost(url);
                }
                builder.get();
                break;
            }
            case 1: {
                builder.post(request.getRequestBody());
                break;
            }
            default: {
                HttpLog.e("Unknown request method.", new Object[0]);
                builder.get();
            }
        }
        builder.url(url);
        return builder.build();
    }

    public static String switchToBackupHost(String url) {
        if (url != null) {
            if (url.indexOf(DXIMSCREENSHOT) != -1) {
                url = url.replaceAll(DXIMSCREENSHOT, WTIMSCREENSHOT);
            } else if (url.indexOf(WTIMSCREENSHOT) != -1) {
                url = url.replaceAll(WTIMSCREENSHOT, DXIMSCREENSHOT);
            }
        }
        MLog.info("Httplog", "switchToBackupHost url=%s", url);
        return url;
    }
}

