/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.taskexecutor;

import android.os.Build;
import android.os.StrictMode;
import android.util.Log;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

final class RuntimeCompat {
    private static final String TAG = "YYRuntimeCompat";
    private static final String CPU_NAME_REGEX = "cpu[0-9]+";
    private static final String CPU_LOCATION = "/sys/devices/system/cpu/";
    private static int bestThreadCount = 0;

    private RuntimeCompat() {
    }

    static int availableProcessors() {
        int cpus = Runtime.getRuntime().availableProcessors();
        if (Build.VERSION.SDK_INT < 17) {
            cpus = Math.max(RuntimeCompat.getCoreCountPre17(), cpus);
        }
        return cpus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCoreCountPre17() {
        File[] cpus = null;
        StrictMode.ThreadPolicy originalPolicy = StrictMode.allowThreadDiskReads();
        try {
            File cpuInfo = new File(CPU_LOCATION);
            final Pattern cpuNamePattern = Pattern.compile(CPU_NAME_REGEX);
            cpus = cpuInfo.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String s) {
                    return cpuNamePattern.matcher(s).matches();
                }
            });
        }
        catch (Throwable t) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                Log.e((String)TAG, (String)"Failed to calculate accurate cpu count", (Throwable)t);
            }
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)originalPolicy);
        }
        return Math.max(1, cpus != null ? cpus.length : 0);
    }

    public static int calculateBestThreadCount() {
        if (bestThreadCount == 0) {
            bestThreadCount = RuntimeCompat.availableProcessors();
        }
        MLog.info(TAG, "core_pool_size:" + bestThreadCount, new Object[0]);
        return bestThreadCount;
    }
}

