/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.optional;

import com.yy.mobile.util.optional.NoSuchElementException;

public final class Optional<T> {
    private T value;

    private Optional(T value) {
        this.value = value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public T get() throws NoSuchElementException {
        if (this.isPresent()) {
            return this.value;
        }
        throw new NoSuchElementException("Optional is not present.");
    }

    public T orElse(T other) {
        if (this.isPresent()) {
            return this.value;
        }
        return other;
    }

    public int hashCode() {
        if (this.isPresent()) {
            return this.value.hashCode();
        }
        return 0;
    }

    public String toString() {
        if (this.isPresent()) {
            return this.value.toString();
        }
        return "Empty optional";
    }

    public static <T> Optional<T> of(T value) {
        return new Optional<T>(value);
    }

    public static <T> Optional<T> empty() {
        return new Optional<Object>(null);
    }
}

