/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.log.logger.printer.transformation;

import android.os.Process;
import android.util.Log;
import com.yy.mobile.util.log.logger.Utils;
import com.yy.mobile.util.log.logger.printer.transformation.DateFormater;
import com.yy.mobile.util.log.logger.printer.transformation.ILogTransformation;

public class GeneralTransformation
implements ILogTransformation {
    private static final String PID = String.valueOf(Process.myPid()) + "-";
    private StringBuilder mStringBuilder = new StringBuilder();
    private DateFormater mDataFormat;

    public GeneralTransformation() {
        this(null);
    }

    public GeneralTransformation(DateFormater dateFormater) {
        this.mDataFormat = dateFormater == null ? new DateFormater() : dateFormater;
    }

    @Override
    public String log(String level, long time, String thread, String tag, Throwable throwable, String msgWithFormat, Object ... args) {
        if (this.mDataFormat == null) {
            return "";
        }
        this.mStringBuilder.append(this.mDataFormat.getDateAndTime(time)).append(" ").append(thread).append(" ").append(level).append(tag).append(": ").append(Utils.createMessage(msgWithFormat, args)).append('\n');
        if (throwable != null) {
            this.mStringBuilder.append(" Exception occurs at ").append(Log.getStackTraceString((Throwable)throwable)).append('\n');
        }
        String result = this.mStringBuilder.toString();
        this.mStringBuilder.delete(0, this.mStringBuilder.length());
        return result;
    }
}

