/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.log.logger.printer;

import com.yy.mobile.util.log.PerfLog;
import com.yy.mobile.util.log.logger.ILogProtection;
import com.yy.mobile.util.log.logger.LogProtection;
import com.yy.mobile.util.log.logger.Utils;
import com.yy.mobile.util.log.logger.printer.AndroidPrinter;
import com.yy.mobile.util.log.logger.printer.IPrinter;
import com.yy.mobile.util.log.logger.printer.IPrinterFactory;
import com.yy.mobile.util.log.logger.printer.filestrategy.IFileStrategy;
import com.yy.mobile.util.log.logger.printer.filestrategy.SectionFileStrategy;
import com.yy.mobile.util.log.logger.printer.transformation.GeneralTransformation;
import com.yy.mobile.util.log.logger.printer.transformation.ILogTransformation;
import com.yy.mobile.util.log.logger.printer.writer.AbstractFileWriter;
import com.yy.mobile.util.log.logger.printer.writer.BufferedFileWriter;
import com.yy.mobile.util.log.logger.printer.writer.IPrinterListener;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public class LocalFilePrinter
implements IPrinter {
    private static final String TAG = "LocalFilePrinter";
    private AbstractFileWriter mWiter;
    private ILogTransformation mLogTransformer;
    private IFileStrategy mFileStrategy;
    private File mCurruntLogFile;
    private IPrinterListener mListener;
    private ILogProtection mLogProtection;

    public LocalFilePrinter() {
        this(null, null, null);
    }

    private LocalFilePrinter(IFileStrategy fileStrategy, AbstractFileWriter fileWriter, ILogTransformation logTransformation) {
        this.mFileStrategy = fileStrategy == null ? new SectionFileStrategy() : fileStrategy;
        this.mWiter = fileWriter == null ? new BufferedFileWriter() : fileWriter;
        this.mLogTransformer = logTransformation == null ? new GeneralTransformation() : logTransformation;
        this.mLogProtection = new LogProtection();
    }

    @Override
    public void log(String level, long time, String thread, String tag, Throwable throwable, String msgWithFormat, Object ... args) {
        block7: {
            if (this.mLogProtection.errWarning()) {
                AndroidPrinter.log("I/:", TAG, null, "mLogProtection.errWarning()", new Object[0]);
                return;
            }
            String msg = this.mLogTransformer.log(level, time, thread, tag, throwable, msgWithFormat, args);
            if (msg != null && msg.length() > 0) {
                File file = this.mFileStrategy.getFile();
                if (file == null) {
                    return;
                }
                if (file != this.mCurruntLogFile) {
                    this.updateNewFile(file);
                    if (this.mListener != null && this.mCurruntLogFile != null) {
                        this.mListener.onLogFileNameChanged(this.mCurruntLogFile.getAbsolutePath());
                    }
                }
                try {
                    this.mWiter.writer(msg, time);
                }
                catch (IOException e) {
                    AndroidPrinter.log("E/:", TAG, e, " writer error %s", file.getAbsolutePath());
                    PerfLog.webLog("mlog", "\u5199\u65e5\u5fd7\u5931\u8d25\uff0c\u518d\u5efa\u65b0\u6587\u4ef6 " + e.getMessage());
                    File old = this.mCurruntLogFile;
                    this.updateNewFile(this.mCurruntLogFile);
                    if (this.mListener == null || this.mCurruntLogFile == null || old == this.mCurruntLogFile) break block7;
                    this.mListener.onLogFileNameChanged(this.mCurruntLogFile.getAbsolutePath());
                }
            }
        }
    }

    @Override
    public void updatePath(String dir, String fileNamePrefix) {
        if (Utils.isEmpty(dir).booleanValue() || Utils.isEmpty(fileNamePrefix).booleanValue()) {
            throw new RuntimeException("LocalFilePrinterlogDir and logName must be not empty!");
        }
        this.mFileStrategy.updatePath(dir, fileNamePrefix);
    }

    @Override
    public String getCurrentLogFilePath() {
        if (this.mCurruntLogFile != null) {
            return this.mCurruntLogFile.getAbsolutePath();
        }
        return "";
    }

    @Override
    public void setListener(IPrinterListener listener) {
        this.mListener = listener;
    }

    @Override
    public void setBuffered(boolean buffered) {
        if (this.mWiter != null) {
            this.mWiter.setBuffered(buffered);
        }
    }

    @Override
    public void flush(boolean forced) {
        if (this.mWiter != null) {
            try {
                this.mWiter.flush(forced);
            }
            catch (IOException e) {
                this.log("E/:", 0L, "", TAG, e, " flush error" + (forced ? "true" : "false"), new Object[0]);
                PerfLog.webLog("mlog", "flush error " + (forced ? "true" : "false") + " " + e.getMessage());
                AndroidPrinter.log("E/:", TAG, e, " flush error" + (forced ? "true" : "false"), new Object[0]);
            }
        }
    }

    private void updateNewFile(File file) {
        Writer writer;
        block6: {
            if (file == null) {
                return;
            }
            this.ensureFileExist(file);
            writer = null;
            try {
                this.mCurruntLogFile = file;
                writer = this.mWiter.createWrite(this.mCurruntLogFile);
            }
            catch (IOException e) {
                this.mLogProtection.active();
                PerfLog.webLog("mlog", "updateNewFile error " + e.getMessage());
                AndroidPrinter.log("E/:", TAG, e, " updateNewFile error %s", file.getAbsolutePath());
                this.mCurruntLogFile = null;
                file = this.createNewFile();
                if (file == null) break block6;
                try {
                    this.mCurruntLogFile = file;
                    writer = this.mWiter.createWrite(this.mCurruntLogFile);
                }
                catch (IOException e2) {
                    this.mCurruntLogFile = null;
                    PerfLog.webLog("mlog", " updateNewFile error retry " + e2.getMessage());
                    AndroidPrinter.log("E/:", TAG, e2, " updateNewFile error retry %s", file.getAbsolutePath());
                }
            }
        }
        if (writer != null) {
            this.mWiter.update(writer);
        }
    }

    private void ensureFileExist(File file) {
        Utils.ensureFileExist(file);
    }

    private File createNewFile() {
        return this.mFileStrategy.createNewFileForce();
    }

    public static class LocalFilePrinterFactory
    implements IPrinterFactory {
        private AbstractFileWriter mWiter;
        private ILogTransformation mLogTransformer;
        private IFileStrategy mFileStrategy;

        private LocalFilePrinterFactory(IFileStrategy fileStrategy, AbstractFileWriter fileWriter, ILogTransformation logTransformation) {
            this.mFileStrategy = fileStrategy;
            this.mWiter = fileWriter;
            this.mLogTransformer = logTransformation;
        }

        @Override
        public IPrinter getPrinter() {
            return new LocalFilePrinter(this.mFileStrategy, this.mWiter, this.mLogTransformer);
        }
    }
}

