/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.log.logger;

import android.os.Process;
import android.util.Log;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.log.PerfLog;
import com.yy.mobile.util.log.logger.AbstractLogger;
import com.yy.mobile.util.log.logger.IQueueExecutor;
import com.yy.mobile.util.log.logger.Utils;
import com.yy.mobile.util.log.logger.printer.AndroidPrinter;
import com.yy.mobile.util.log.logger.printer.IPrinter;
import com.yy.mobile.util.log.logger.printer.IPrinterFactory;
import com.yy.mobile.util.log.logger.printer.LocalFilePrinter;
import com.yy.mobile.util.log.logger.printer.writer.IPrinterListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class GeneralLogger
extends AbstractLogger {
    private static final String TAG = "GeneralLogger";
    private IQueueExecutor mExecutor;
    private IPrinter mPrinter;
    private boolean mOpenAndroidLog;
    private boolean mStoped;

    private GeneralLogger(IPrinter printer, IQueueExecutor executor) {
        this.mExecutor = executor;
        if (this.mExecutor == null) {
            this.initExecutor();
        }
        this.mPrinter = printer;
    }

    public void updatePath(String dir, String fileNamePrefix) {
        this.mPrinter.updatePath(dir, fileNamePrefix);
    }

    public void setPrinterListener(IPrinterListener listener) {
        this.mPrinter.setListener(listener);
    }

    public String getCurrentLogFilePath() {
        return this.mPrinter.getCurrentLogFilePath();
    }

    @Override
    public void flush() {
        if (this.mExecutor != null && this.mExecutor instanceof MyExcutor) {
            if (this.mExecutor instanceof Thread) {
                Process.setThreadPriority((int)10);
            }
            ((MyExcutor)this.mExecutor).flush(new Runnable(){

                @Override
                public void run() {
                    if (GeneralLogger.this.mOutputLevel < 3) {
                        GeneralLogger.this.log("I/:", System.currentTimeMillis(), "", GeneralLogger.TAG, null, "flush!", new Object[0]);
                    }
                    GeneralLogger.this.mPrinter.flush(true);
                    if (GeneralLogger.this.mOutputLevel < 3) {
                        GeneralLogger.this.log("I/:", System.currentTimeMillis(), "", GeneralLogger.TAG, null, "flush end!", new Object[0]);
                    }
                    Thread thread = Thread.currentThread();
                    thread.setPriority(5);
                }
            });
        }
    }

    @Override
    public void stop() {
        if (this.mExecutor instanceof MyExcutor) {
            ((MyExcutor)this.mExecutor).doStop();
        }
        this.mExecutor = null;
        this.mStoped = true;
    }

    @Override
    public void setOutputLevel(int level) {
        super.setOutputLevel(level);
    }

    public void setOpenAndroidLogFlag(boolean open) {
        this.mOpenAndroidLog = open;
    }

    private void initExecutor() {
        MyExcutor executor = new MyExcutor();
        this.mExecutor = executor;
        executor.start();
    }

    @Override
    public void log(String level, long time, String thread, String tag, Throwable throwable, String msgWithFormat, Object ... args) {
        if (this.mOpenAndroidLog) {
            AndroidPrinter.log(level, tag, throwable, msgWithFormat, args);
        }
        if (this.mExecutor == null || this.mPrinter == null) {
            return;
        }
        LoggerRunnable runnable = LoggerRunnable.obtain();
        runnable.throwable = throwable;
        runnable.level = level;
        runnable.time = time;
        runnable.thread = thread;
        runnable.tag = tag;
        runnable.msgWithFormat = msgWithFormat;
        runnable.args = args;
        runnable.printer = this.mPrinter;
        this.mExecutor.execute(runnable);
    }

    private static String safeParse(Throwable e) {
        if (e == null) {
            return "";
        }
        return e.getMessage();
    }

    static /* synthetic */ String access$200(Throwable x0) {
        return GeneralLogger.safeParse(x0);
    }

    private static class MyExcutor
    extends Thread
    implements IQueueExecutor {
        private static final int MAX_UNKNOWN_EXCEPTION = 5;
        private final BlockingQueue<Runnable> mQueue = new LinkedBlockingQueue<Runnable>();
        private Runnable mRunnableToRun;
        private int mCatchNum = 0;
        private volatile Runnable mFlushRunable = null;

        @Override
        public void start() {
            super.start();
        }

        public void doStop() {
            try {
                this.mQueue.clear();
            }
            catch (Exception e) {
                Log.e((String)GeneralLogger.TAG, (String)"doStop() error", (Throwable)e);
                PerfLog.webLog("mlog", "doStop() error " + e.getMessage());
            }
        }

        public void flush(Runnable flushRunable) {
            this.mFlushRunable = flushRunable;
        }

        @Override
        public void execute(Runnable runnable) {
            block3: {
                if (this.mCatchNum > 5) {
                    Log.e((String)GeneralLogger.TAG, (String)"GeneralLogger is stop working !");
                    return;
                }
                try {
                    this.mQueue.put(runnable);
                }
                catch (InterruptedException e) {
                    if (!BasicConfig.getInstance().isDebuggable()) break block3;
                    Log.e((String)GeneralLogger.TAG, (String)"put log runnable error", (Throwable)e);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            this.setName("GeneralLog Thread");
            while (true) {
                if (this.mFlushRunable != null) {
                    this.mFlushRunable.run();
                    this.mFlushRunable = null;
                }
                try {
                    this.mRunnableToRun = this.mQueue.take();
                    if (this.mRunnableToRun == null) continue;
                    this.mRunnableToRun.run();
                    continue;
                }
                catch (InterruptedException e) {
                    Log.e((String)"GeneralLogger", (String)"run error 1", (Throwable)e);
                    PerfLog.webLog("mlog", "run error 1 " + GeneralLogger.access$200(e));
                    continue;
                }
                catch (NullPointerException ex) {
                    Log.e((String)"GeneralLogger", (String)"run error 2", (Throwable)ex);
                    PerfLog.webLog("mlog", "run error 2 " + GeneralLogger.access$200(ex));
                    continue;
                }
                catch (Throwable e) {
                    ++this.mCatchNum;
                    if (this.mCatchNum > 5) ** break;
                    continue;
                    Log.e((String)"GeneralLogger", (String)"error MAX_UNKNOWN_EXCEPTION", (Throwable)e);
                    PerfLog.webLog("mlog", "error MAX_UNKNOWN_EXCEPTION " + GeneralLogger.access$200(e));
                    return;
                }
                break;
            }
        }
    }

    private static class LoggerRunnable
    implements Runnable {
        public Throwable throwable;
        public String level;
        public String thread;
        public String tag;
        public String msgWithFormat;
        public Object[] args;
        public long time;
        public IPrinter printer;
        private LoggerRunnable mNext;
        private static int sPoolSize = 0;
        private static final int MAX_POOL_SIZE = 500;
        private static final Object sPoolSync = new Object();
        private static LoggerRunnable sPool;

        private LoggerRunnable() {
        }

        @Override
        public void run() {
            if (this.printer == null) {
                return;
            }
            this.printer.log(this.level, this.time, this.thread, this.tag, this.throwable, this.msgWithFormat, this.args);
            this.recycle();
        }

        private void reset() {
            this.thread = null;
            this.level = null;
            this.tag = null;
            this.msgWithFormat = null;
            this.args = null;
            this.time = 0L;
            this.throwable = null;
            this.printer = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static LoggerRunnable obtain() {
            Object object = sPoolSync;
            synchronized (object) {
                if (sPool != null) {
                    LoggerRunnable m = sPool;
                    sPool = m.mNext;
                    m.mNext = null;
                    --sPoolSize;
                    return m;
                }
            }
            return new LoggerRunnable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recycle() {
            this.reset();
            Object object = sPoolSync;
            synchronized (object) {
                if (sPoolSize < 500) {
                    this.mNext = sPool;
                    sPool = this;
                    ++sPoolSize;
                }
            }
        }
    }

    public static class Builder {
        private IPrinter mPrinter;
        private String mDir;
        private String mFileNamePrefix;
        private IQueueExecutor mExecutor;
        private int mLogLevel;
        private boolean mOpenAndroidLog;
        private IPrinterListener mPrinterListener;

        private Builder(String dir, String fileNamePrefix) {
            this.mDir = dir;
            this.mFileNamePrefix = fileNamePrefix;
        }

        public static Builder obtain(String dir, String logNamePrefix) {
            if (Utils.isEmpty(dir).booleanValue() || Utils.isEmpty(logNamePrefix).booleanValue()) {
                throw new RuntimeException("GeneralLoggerlogDir and logName must be not empty!");
            }
            return new Builder(dir, logNamePrefix);
        }

        public Builder setOpenAndroidLogFlag(boolean open) {
            this.mOpenAndroidLog = open;
            return this;
        }

        public Builder setOutputLevel(int level) {
            this.mLogLevel = level;
            return this;
        }

        public Builder setExecutor(IQueueExecutor executor) {
            this.mExecutor = executor;
            return this;
        }

        public Builder setPrinterFactory(IPrinterFactory iPrinterFactory) {
            this.mPrinter = iPrinterFactory != null ? iPrinterFactory.getPrinter() : null;
            return this;
        }

        public Builder setPrinterListener(IPrinterListener listener) {
            this.mPrinterListener = listener;
            return this;
        }

        public GeneralLogger build() {
            if (this.mPrinter == null) {
                this.mPrinter = new LocalFilePrinter();
            }
            this.mPrinter.updatePath(this.mDir, this.mFileNamePrefix);
            this.mPrinter.setListener(this.mPrinterListener);
            GeneralLogger generalLogger = new GeneralLogger(this.mPrinter, this.mExecutor);
            generalLogger.setOutputLevel(this.mLogLevel);
            generalLogger.setOpenAndroidLogFlag(this.mOpenAndroidLog);
            return generalLogger;
        }
    }
}

