/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.log;

import android.support.v4.util.Pair;
import android.util.Log;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.log.LogCompress;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.log.PerfLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import tv.athena.util.TimeUtils;

public class LogZipCompress
implements LogCompress {
    private static LogZipCompress mInstance;
    public static final String EXT = ".zip";
    private static final String BASE_DIR = "";
    private static final String PATH = "/";
    private static final int BUFFER = 1024;

    private LogZipCompress() {
    }

    public static synchronized LogZipCompress getInstance() {
        if (mInstance == null) {
            mInstance = new LogZipCompress();
        }
        return mInstance;
    }

    @Override
    public void compress(File srcFile) throws Exception {
        String name = srcFile.getName();
        String basePath = srcFile.getParent();
        String destPath = basePath + File.separator + name.substring(0, name.indexOf(".")) + EXT;
        this.compress(srcFile, destPath);
    }

    public void compress(File srcFile, File destFile) throws Exception {
        CheckedOutputStream cos = new CheckedOutputStream(new FileOutputStream(destFile), new CRC32());
        ZipOutputStream zos = new ZipOutputStream(cos);
        this.compress(srcFile, zos, BASE_DIR);
        zos.flush();
        zos.close();
    }

    public void compress(File srcFile, String destPath) throws Exception {
        this.compress(srcFile, new File(destPath));
    }

    private void compress(File srcFile, ZipOutputStream zos, String basePath) throws Exception {
        if (srcFile.isDirectory()) {
            this.compressDir(srcFile, zos, basePath);
        } else {
            this.compressFile(srcFile, zos, basePath);
        }
    }

    public void compress(String srcPath) throws Exception {
        File srcFile = new File(srcPath);
        this.compress(srcFile);
    }

    public void compress(String srcPath, String destPath) throws Exception {
        File srcFile = new File(srcPath);
        this.compress(srcFile, destPath);
    }

    private void compressDir(File dir, ZipOutputStream zos, String basePath) throws Exception {
        File[] files = dir.listFiles();
        if (files.length < 1) {
            ZipEntry entry = new ZipEntry(basePath + dir.getName() + PATH);
            zos.putNextEntry(entry);
            zos.closeEntry();
            for (File file : files) {
                this.compress(file, zos, basePath + dir.getName() + PATH);
            }
        }
    }

    private void compressFile(File file, ZipOutputStream zos, String dir) throws Exception {
        int count;
        ZipEntry entry = new ZipEntry(dir + file.getName());
        zos.putNextEntry(entry);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        byte[] data = new byte[1024];
        while ((count = bis.read(data, 0, 1024)) != -1) {
            zos.write(data, 0, count);
        }
        bis.close();
        zos.closeEntry();
    }

    public Pair<Integer, String> compressFiles(List<File> files, long uid) {
        if (files.size() <= 0) {
            return new Pair((Object)-1012, (Object)BASE_DIR);
        }
        String zipPath = uid == 0L ? MLog.getLogOutputPaths().dir + File.separator + "Android_unknown_userId_" + CommonUtils.getSimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(System.currentTimeMillis()) + EXT : MLog.getLogOutputPaths().dir + File.separator + "Android_" + uid + "_" + CommonUtils.getSimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(System.currentTimeMillis()) + EXT;
        Pair<Integer, String> pair = this.compressFiles(files, zipPath);
        if ((Integer)pair.first != 0) {
            pair = this.compressFiles(files, zipPath);
        }
        return pair;
    }

    public Pair<Integer, String> compressFiles(List<File> files, String zipPath) {
        byte[] buffer = new byte[1024];
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        File zipFile = new File(zipPath);
        if (zipFile.exists()) {
            zipFile.delete();
        }
        try {
            zipFile.createNewFile();
        }
        catch (IOException e) {
            MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
            PerfLog.webLog("log_compress", "compressFiles zipFile.createNewFile() " + e.getMessage());
            return new Pair((Object)-101, (Object)BASE_DIR);
        }
        try {
            fos = new FileOutputStream(zipPath);
        }
        catch (FileNotFoundException e) {
            MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
            PerfLog.webLog("log_compress", "compressFiles new FileOutputStream(zipPath) " + e.getMessage());
            return new Pair((Object)-102, (Object)BASE_DIR);
        }
        zos = new ZipOutputStream(fos);
        for (File file : files) {
            if (file == null || !file.exists()) continue;
            if (file.isDirectory()) {
                File[] subFiles;
                for (File f : subFiles = file.listFiles()) {
                    if (f.isDirectory()) continue;
                    ZipEntry ze = new ZipEntry(file.getName() + File.separator + f.getName());
                    try {
                        zos.putNextEntry(ze);
                    }
                    catch (IOException e) {
                        MLog.error((Object)"LogZipCompress", "printStackTrace", e.getMessage());
                        PerfLog.webLog("log_compress", "compressFiles zos.putNextEntry(ze) " + e.getMessage());
                        this.deleteFile(zipFile);
                        return new Pair((Object)-103, (Object)BASE_DIR);
                    }
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(f);
                    }
                    catch (FileNotFoundException e) {
                        MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                        PerfLog.webLog("log_compress", "compressFiles new FileInputStream(f) " + e.getMessage());
                        this.deleteFile(zipFile);
                        return new Pair((Object)-104, (Object)BASE_DIR);
                    }
                    try {
                        int len;
                        while ((len = in.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                    }
                    catch (IOException e) {
                        MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                        PerfLog.webLog("log_compress", "compressFiles zos.write(buffer, 0, len) " + e.getMessage());
                        this.deleteFile(zipFile);
                        return new Pair((Object)-105, (Object)BASE_DIR);
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                        PerfLog.webLog("log_compress", "compressFiles in.close() " + e.getMessage());
                        this.deleteFile(zipFile);
                        return new Pair((Object)-106, (Object)BASE_DIR);
                    }
                }
                continue;
            }
            ZipEntry ze = new ZipEntry(file.getName());
            try {
                zos.putNextEntry(ze);
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                PerfLog.webLog("log_compress", "compressFiles zos.putNextEntry(ze) " + e.getMessage());
                this.deleteFile(zipFile);
                return new Pair((Object)-107, (Object)BASE_DIR);
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                PerfLog.webLog("log_compress", "compressFiles in.close() " + e.getMessage());
                this.deleteFile(zipFile);
                return new Pair((Object)-108, (Object)BASE_DIR);
            }
            try {
                int len;
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                PerfLog.webLog("log_compress", "compressFiles zos.write(buffer, 0, len) " + e.getMessage());
                this.deleteFile(zipFile);
                return new Pair((Object)-109, (Object)BASE_DIR);
            }
            try {
                in.close();
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                PerfLog.webLog("log_compress", "compressFiles in.close() " + e.getMessage());
                this.deleteFile(zipFile);
                return new Pair((Object)-1010, (Object)BASE_DIR);
            }
        }
        try {
            zos.closeEntry();
            zos.close();
        }
        catch (IOException e) {
            MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
            PerfLog.webLog("log_compress", "compressFiles zos.closeEntry();zos.close(); " + e.getMessage());
            return new Pair((Object)-1011, (Object)BASE_DIR);
        }
        return new Pair((Object)0, (Object)zipFile.getAbsolutePath());
    }

    public Pair<Integer, String> compressFiles(List<File> commonLogfiles, List<File> sdkLogfiles, long uid) {
        if (commonLogfiles.size() + sdkLogfiles.size() <= 0) {
            return new Pair((Object)-1012, (Object)BASE_DIR);
        }
        String zipPath = uid == 0L ? MLog.getLogOutputPaths().dir + File.separator + "Android_unknown_userId_" + CommonUtils.getSimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(System.currentTimeMillis()) + EXT : MLog.getLogOutputPaths().dir + File.separator + "Android_" + uid + "_" + CommonUtils.getSimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(System.currentTimeMillis()) + EXT;
        Pair<Integer, String> pair = this.compressFiles(commonLogfiles, sdkLogfiles, zipPath);
        if ((Integer)pair.first != 0) {
            pair = this.compressFiles(commonLogfiles, sdkLogfiles, zipPath);
        }
        return pair;
    }

    public Pair<Integer, String> compressFiles(List<File> files, long uid, String logPath) {
        if (files.size() <= 0) {
            return new Pair((Object)-1012, (Object)BASE_DIR);
        }
        String zipPath = uid == 0L ? logPath + File.separator + "Android_unknown_userId_" + TimeUtils.getSimpleDateFormat((String)"yyyy-MM-dd-HH-mm-ss").format(System.currentTimeMillis()) + EXT : logPath + File.separator + "Android_" + uid + "_" + TimeUtils.getSimpleDateFormat((String)"yyyy-MM-dd-HH-mm-ss").format(System.currentTimeMillis()) + EXT;
        byte[] buffer = new byte[1024];
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        File zipFile = new File(zipPath);
        if (zipFile.exists()) {
            zipFile.delete();
        }
        try {
            zipFile.createNewFile();
        }
        catch (IOException e) {
            Log.e((String)"LogZipCompress", (String)"printStackTrace", (Throwable)e);
            MLog.error((Object)"LogZipCompress", "compressFiles zipFile.createNewFile()", e, new Object[0]);
            return new Pair((Object)-101, (Object)BASE_DIR);
        }
        try {
            fos = new FileOutputStream(zipPath);
        }
        catch (FileNotFoundException e) {
            Log.e((String)"LogZipCompress", (String)"fos = new FileOutputStream(zipPath)", (Throwable)e);
            MLog.error((Object)"LogZipCompress", "compressFiles fos = new FileOutputStream(zipPath)", e, new Object[0]);
            return new Pair((Object)-102, (Object)BASE_DIR);
        }
        zos = new ZipOutputStream(fos);
        for (File file : files) {
            if (file == null || !file.exists()) continue;
            if (file.isDirectory()) {
                File[] subFiles;
                for (File f : subFiles = file.listFiles()) {
                    if (f.isDirectory()) continue;
                    ZipEntry ze = new ZipEntry(file.getName());
                    try {
                        zos.putNextEntry(ze);
                    }
                    catch (IOException e) {
                        Log.e((String)"LogZipCompress", (String)"printStackTrace", (Throwable)e);
                        MLog.error((Object)"LogZipCompress", "compressFiles zos.putNextEntry(ze)", e, new Object[0]);
                        this.deleteFile(zipFile);
                        return new Pair((Object)-103, (Object)BASE_DIR);
                    }
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(f);
                    }
                    catch (FileNotFoundException e) {
                        Log.e((String)"LogZipCompress", (String)"printStackTrace", (Throwable)e);
                        MLog.error((Object)"LogZipCompress", "compressFiles in = new FileInputStream(f)", e, new Object[0]);
                        this.deleteFile(zipFile);
                        return new Pair((Object)-104, (Object)BASE_DIR);
                    }
                    try {
                        int len;
                        while ((len = in.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                    }
                    catch (IOException e) {
                        Log.e((String)"LogZipCompress", (String)"printStackTrace", (Throwable)e);
                        MLog.error((Object)"LogZipCompress", "compressFiles zos.write(buffer, 0, len)", e, new Object[0]);
                        this.deleteFile(zipFile);
                        return new Pair((Object)-105, (Object)BASE_DIR);
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        Log.e((String)"LogZipCompress", (String)"printStackTrace", (Throwable)e);
                        MLog.error((Object)"LogZipCompress", "compressFiles in.close()", e, new Object[0]);
                        this.deleteFile(zipFile);
                        return new Pair((Object)-106, (Object)BASE_DIR);
                    }
                }
                continue;
            }
            ZipEntry ze = new ZipEntry(file.getName());
            try {
                zos.putNextEntry(ze);
            }
            catch (IOException e) {
                Log.e((String)"LogZipCompress", (String)"printStackTrace", (Throwable)e);
                MLog.error((Object)"LogZipCompress", "compressFiles zos.putNextEntry(ze)", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-107, (Object)BASE_DIR);
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                Log.e((String)"LogZipCompress", (String)"printStackTrace", (Throwable)e);
                MLog.error((Object)"LogZipCompress", "compressFiles in = new FileInputStream(file)", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-108, (Object)BASE_DIR);
            }
            try {
                int len;
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                Log.e((String)"LogZipCompress", (String)"printStackTrace", (Throwable)e);
                MLog.error((Object)"LogZipCompress", "compressFiles zos.write(buffer, 0, len)", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-109, (Object)BASE_DIR);
            }
            try {
                in.close();
            }
            catch (IOException e) {
                Log.e((String)"LogZipCompress", (String)"printStackTrace", (Throwable)e);
                MLog.error((Object)"LogZipCompress", "compressFiles in.close()", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-1010, (Object)BASE_DIR);
            }
        }
        try {
            zos.closeEntry();
            zos.close();
        }
        catch (IOException e) {
            Log.e((String)"LogZipCompress", (String)"printStackTrace", (Throwable)e);
            MLog.error((Object)"LogZipCompress", "compressFiles zos.closeEntry()", e, new Object[0]);
            return new Pair((Object)-1011, (Object)BASE_DIR);
        }
        return new Pair((Object)0, (Object)zipFile.getAbsolutePath());
    }

    public Pair<Integer, String> compressFiles(List<File> commonLogfiles, List<File> sdkLogfiles, String zipPath) {
        int len;
        FileInputStream in;
        ZipEntry ze;
        byte[] buffer = new byte[1024];
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        File zipFile = new File(zipPath);
        if (zipFile.exists()) {
            zipFile.delete();
        }
        try {
            zipFile.createNewFile();
        }
        catch (IOException e) {
            MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
            PerfLog.webLog("log_compress", "LogZipCompress zipFile.createNewFile() " + e.getMessage());
            return new Pair((Object)-101, (Object)BASE_DIR);
        }
        try {
            fos = new FileOutputStream(zipPath);
        }
        catch (FileNotFoundException e) {
            MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
            PerfLog.webLog("log_compress", "LogZipCompress new FileOutputStream(zipPath) " + e.getMessage());
            return new Pair((Object)-102, (Object)BASE_DIR);
        }
        zos = new ZipOutputStream(fos);
        for (File file : commonLogfiles) {
            if (file == null || !file.exists()) continue;
            ze = new ZipEntry(file.getName());
            try {
                zos.putNextEntry(ze);
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                PerfLog.webLog("log_compress", "LogZipCompress zos.putNextEntry(ze) " + e.getMessage());
                this.deleteFile(zipFile);
                return new Pair((Object)-107, (Object)BASE_DIR);
            }
            in = null;
            try {
                in = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                PerfLog.webLog("log_compress", "LogZipCompress new FileInputStream(file) " + e.getMessage());
                this.deleteFile(zipFile);
                return new Pair((Object)-108, (Object)BASE_DIR);
            }
            try {
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                PerfLog.webLog("log_compress", "LogZipCompress zos.write(buffer, 0, len) " + e.getMessage());
                this.deleteFile(zipFile);
                return new Pair((Object)-109, (Object)BASE_DIR);
            }
            try {
                in.close();
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                PerfLog.webLog("log_compress", "LogZipCompress in.close() " + e.getMessage());
                this.deleteFile(zipFile);
                return new Pair((Object)-1010, (Object)BASE_DIR);
            }
        }
        for (File f : sdkLogfiles) {
            if (f.isDirectory()) continue;
            ze = new ZipEntry("sdklog" + File.separator + f.getName());
            try {
                zos.putNextEntry(ze);
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                PerfLog.webLog("log_compress", "LogZipCompress zos.putNextEntry(ze) " + e.getMessage());
                this.deleteFile(zipFile);
                return new Pair((Object)-103, (Object)BASE_DIR);
            }
            in = null;
            try {
                in = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                PerfLog.webLog("log_compress", "LogZipCompress new FileInputStream(f) " + e.getMessage());
                this.deleteFile(zipFile);
                return new Pair((Object)-104, (Object)BASE_DIR);
            }
            try {
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                PerfLog.webLog("log_compress", "LogZipCompress zos.write(buffer, 0, len) " + e.getMessage());
                this.deleteFile(zipFile);
                return new Pair((Object)-105, (Object)BASE_DIR);
            }
            try {
                in.close();
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                PerfLog.webLog("log_compress", "LogZipCompress in.close() " + e.getMessage());
                this.deleteFile(zipFile);
                return new Pair((Object)-106, (Object)BASE_DIR);
            }
        }
        try {
            zos.closeEntry();
            zos.close();
        }
        catch (IOException e) {
            MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
            PerfLog.webLog("log_compress", "LogZipCompress zos.closeEntry();zos.close() " + e.getMessage());
            return new Pair((Object)-1011, (Object)BASE_DIR);
        }
        return new Pair((Object)0, (Object)zipFile.getAbsolutePath());
    }

    private void deleteFile(File zipFile) {
        if (zipFile.exists()) {
            zipFile.delete();
        }
    }

    @Override
    public void decompress(File srcFile) throws Exception {
        String basePath = srcFile.getParent() + File.separator;
        this.decompress(srcFile, basePath);
    }

    public void decompress(File srcFile, File destFile) throws Exception {
        CheckedInputStream cis = new CheckedInputStream(new FileInputStream(srcFile), new CRC32());
        ZipInputStream zis = new ZipInputStream(cis);
        this.decompress(destFile, zis);
        zis.close();
    }

    public void decompress(File srcFile, String destPath) throws Exception {
        this.decompress(srcFile, new File(destPath));
    }

    private void decompress(File destFile, ZipInputStream zis) throws Exception {
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            String dir = destFile.getPath() + File.separator + entry.getName();
            File dirFile = new File(dir);
            this.fileProber(dirFile);
            if (entry.isDirectory()) {
                dirFile.mkdirs();
            } else {
                this.decompressFile(dirFile, zis);
            }
            zis.closeEntry();
        }
    }

    public void decompress(String srcPath) throws Exception {
        File srcFile = new File(srcPath);
        this.decompress(srcFile);
    }

    public void decompress(String srcPath, String destPath) throws Exception {
        File srcFile = new File(srcPath);
        this.decompress(srcFile, destPath);
    }

    private void decompressFile(File destFile, ZipInputStream zis) throws Exception {
        int count;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));
        byte[] data = new byte[1024];
        while ((count = zis.read(data, 0, 1024)) != -1) {
            bos.write(data, 0, count);
        }
        bos.write(data);
        bos.close();
    }

    private void fileProber(File dirFile) {
        File parentFile = dirFile.getParentFile();
        if (!parentFile.exists()) {
            this.fileProber(parentFile);
            parentFile.mkdir();
        }
    }
}

