/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.json;

import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.yyprotocol.core.Int64;
import com.yy.mobile.yyprotocol.core.Uint16;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yy.mobile.yyprotocol.core.Uint64;
import com.yy.mobile.yyprotocol.core.Uint8;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonParser {
    public static Gson gson = new GsonBuilder().registerTypeAdapter(Int64.class, (Object)new NumberTypeAdapter()).registerTypeAdapter(Uint8.class, (Object)new NumberTypeAdapter()).registerTypeAdapter(Uint16.class, (Object)new NumberTypeAdapter()).registerTypeAdapter(Uint32.class, (Object)new NumberTypeAdapter()).registerTypeAdapter(Uint64.class, (Object)new NumberTypeAdapter()).disableHtmlEscaping().create();
    static final String TAG = "JsonParse";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T parseJsonObject(String json, Class<T> clz) {
        long t = SystemClock.currentThreadTimeMillis();
        try {
            Object object = gson.fromJson(json, clz);
            return (T)object;
        }
        finally {
            long del;
            if (BasicConfig.getInstance().isDebuggable() && (del = SystemClock.currentThreadTimeMillis() - t) > 20L) {
                Log.e((String)TAG, (String)("cost to much time:" + json.length() + ",clz:" + clz.getName() + ",t:" + del));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T parseJsonObject(JsonElement json, Class<T> clz) {
        long t = SystemClock.currentThreadTimeMillis();
        try {
            Object object = gson.fromJson(json, clz);
            return (T)object;
        }
        finally {
            long del;
            if (BasicConfig.getInstance().isDebuggable() && (del = SystemClock.currentThreadTimeMillis() - t) > 20L) {
                Log.e((String)TAG, (String)("cost to much time clz:" + clz.getName() + ",t:" + del));
            }
        }
    }

    public static <T> T[] parseJsonArray(String json, Class<T> clz) {
        Object[] result = (Object[])gson.fromJson(json, new TypeToken<T[]>(){}.getType());
        return result;
    }

    public static <K, V> Map<K, V> parseJsonMap(String json, Class<K> keyType, Class<V> valueType) {
        Map result = (Map)gson.fromJson(json, new TypeToken<Map<K, V>>(){}.getType());
        return result;
    }

    public static String toJson(Object obj) {
        try {
            return gson.toJson(obj);
        }
        catch (Throwable e) {
            MLog.error((Object)"JsonParser", "wangsong", e, new Object[0]);
            return "{}";
        }
    }

    public static <T> List<T> parseJsonList(String json, Class<T> clz) throws Exception {
        ArrayList<Object> data = new ArrayList<Object>();
        if (!TextUtils.isEmpty((CharSequence)json)) {
            com.google.gson.JsonParser parser = new com.google.gson.JsonParser();
            JsonElement element = parser.parse(json);
            JsonArray array = element.getAsJsonArray();
            for (JsonElement jo : array) {
                data.add(gson.fromJson(jo, clz));
            }
        }
        return data;
    }

    public static <T> List<T> parseJsonList(JsonArray array, Class<T> clz) throws Exception {
        ArrayList<T> data = new ArrayList<T>();
        for (JsonElement jo : array) {
            data.add(JsonParser.parseJsonObject(jo, clz));
        }
        return data;
    }

    private static class NumberTypeAdapter
    implements JsonSerializer<Number> {
        private NumberTypeAdapter() {
        }

        public JsonElement serialize(Number src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }
    }
}

