/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.gif;

import android.graphics.Bitmap;
import android.util.Log;
import java.io.InputStream;
import java.util.Vector;

public class GifDecoder {
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    protected static final int MAX_STACK_SIZE = 4096;
    protected InputStream in;
    protected int status;
    protected int width;
    protected int height;
    protected boolean gctFlag;
    protected int gctSize;
    protected int loopCount = 1;
    protected int[] gct;
    protected int[] lct;
    protected int[] act;
    protected int bgIndex;
    protected int bgColor;
    protected int lastBgColor;
    protected int pixelAspect;
    protected boolean lctFlag;
    protected boolean interlace;
    protected int lctSize;
    protected int ix;
    protected int iy;
    protected int iw;
    protected int ih;
    protected int lrx;
    protected int lry;
    protected int lrw;
    protected int lrh;
    protected Bitmap image;
    protected Bitmap lastBitmap;
    protected byte[] block = new byte[256];
    protected int blockSize = 0;
    protected int dispose = 0;
    protected int lastDispose = 0;
    protected boolean transparency = false;
    protected int delay = 0;
    protected int transIndex;
    protected short[] prefix;
    protected byte[] suffix;
    protected byte[] pixelStack;
    protected byte[] pixels;
    protected Vector<GifFrame> frames;
    protected int frameCount;

    public int getDelay(int n) {
        this.delay = -1;
        if (n >= 0 && n < this.frameCount) {
            this.delay = this.frames.elementAt((int)n).delay;
        }
        return this.delay;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public Bitmap getBitmap() {
        return this.getFrame(0);
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    protected void setPixels() {
        int[] dest = new int[this.width * this.height];
        if (this.lastDispose > 0) {
            if (this.lastDispose == 3) {
                int n = this.frameCount - 2;
                this.lastBitmap = n > 0 ? this.getFrame(n - 1) : null;
            }
            if (this.lastBitmap != null) {
                this.lastBitmap.getPixels(dest, 0, this.width, 0, 0, this.width, this.height);
                if (this.lastDispose == 2) {
                    int c = 0;
                    if (!this.transparency) {
                        c = this.lastBgColor;
                    }
                    for (int i = 0; i < this.lrh; ++i) {
                        int n1 = (this.lry + i) * this.width + this.lrx;
                        int n2 = n1 + this.lrw;
                        for (int k = n1; k < n2; ++k) {
                            dest[k] = c;
                        }
                    }
                }
            }
        }
        int pass = 1;
        int inc = 8;
        int iline = 0;
        for (int i = 0; i < this.ih; ++i) {
            int line = i;
            if (this.interlace) {
                if (iline >= this.ih) {
                    switch (++pass) {
                        case 2: {
                            iline = 4;
                            break;
                        }
                        case 3: {
                            iline = 2;
                            inc = 4;
                            break;
                        }
                        case 4: {
                            iline = 1;
                            inc = 2;
                            break;
                        }
                    }
                }
                line = iline;
                iline += inc;
            }
            if ((line += this.iy) >= this.height) continue;
            int k = line * this.width;
            int dx = k + this.ix;
            int dlim = dx + this.iw;
            if (k + this.width < dlim) {
                dlim = k + this.width;
            }
            int sx = i * this.iw;
            while (dx < dlim) {
                int index;
                int c;
                if ((c = this.act[index = this.pixels[sx++] & 0xFF]) != 0) {
                    dest[dx] = c;
                }
                ++dx;
            }
        }
        this.image = Bitmap.createBitmap((int[])dest, (int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_4444);
    }

    public Bitmap getFrame(int n) {
        if (this.frameCount <= 0) {
            return null;
        }
        return this.frames.elementAt((int)(n %= this.frameCount)).image;
    }

    public int read(InputStream is) {
        this.init();
        if (is != null) {
            this.in = is;
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception e) {
            Log.e((String)"GifDecoder", (String)"Empty Catch on read", (Throwable)e);
        }
        return this.status;
    }

    protected void decodeBitmapData() {
        int code;
        int nullCode = -1;
        int npix = this.iw * this.ih;
        if (this.pixels == null || this.pixels.length < npix) {
            this.pixels = new byte[npix];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int dataSize = this.read();
        int clear = 1 << dataSize;
        int endOfInformation = clear + 1;
        int available = clear + 2;
        int oldCode = nullCode;
        int codeSize = dataSize + 1;
        int codeMask = (1 << codeSize) - 1;
        for (code = 0; code < clear; ++code) {
            this.prefix[code] = 0;
            this.suffix[code] = (byte)code;
        }
        int bi = 0;
        int pi = 0;
        int top = 0;
        int first = 0;
        int count = 0;
        int bits = 0;
        int datum = 0;
        int i = 0;
        while (i < npix) {
            if (top == 0) {
                if (bits < codeSize) {
                    if (count == 0) {
                        count = this.readBlock();
                        if (count <= 0) break;
                        bi = 0;
                    }
                    datum += (this.block[bi] & 0xFF) << bits;
                    bits += 8;
                    ++bi;
                    --count;
                    continue;
                }
                code = datum & codeMask;
                datum >>= codeSize;
                bits -= codeSize;
                if (code > available || code == endOfInformation) break;
                if (code == clear) {
                    codeSize = dataSize + 1;
                    codeMask = (1 << codeSize) - 1;
                    available = clear + 2;
                    oldCode = nullCode;
                    continue;
                }
                if (oldCode == nullCode) {
                    this.pixelStack[top++] = this.suffix[code];
                    oldCode = code;
                    first = code;
                    continue;
                }
                int inCode = code;
                if (code == available) {
                    this.pixelStack[top++] = (byte)first;
                    code = oldCode;
                }
                while (code > clear) {
                    this.pixelStack[top++] = this.suffix[code];
                    code = this.prefix[code];
                }
                first = this.suffix[code] & 0xFF;
                if (available >= 4096) break;
                this.pixelStack[top++] = (byte)first;
                this.prefix[available] = (short)oldCode;
                this.suffix[available] = (byte)first;
                if ((++available & codeMask) == 0 && available < 4096) {
                    ++codeSize;
                    codeMask += available;
                }
                oldCode = inCode;
            }
            this.pixels[pi++] = this.pixelStack[--top];
            ++i;
        }
        for (i = pi; i < npix; ++i) {
            this.pixels[i] = 0;
        }
    }

    protected boolean err() {
        return this.status != 0;
    }

    protected void init() {
        this.status = 0;
        this.frameCount = 0;
        this.frames = new Vector();
        this.gct = null;
        this.lct = null;
    }

    protected int read() {
        int curByte = 0;
        try {
            curByte = this.in.read();
        }
        catch (Exception e) {
            this.status = 1;
        }
        return curByte;
    }

    protected int readBlock() {
        int n;
        this.blockSize = this.read();
        if (this.blockSize > 0) {
            try {
                int count = 0;
                for (n = 0; n < this.blockSize && (count = this.in.read(this.block, n, this.blockSize - n)) != -1; n += count) {
                }
            }
            catch (Exception e) {
                Log.e((String)"GifDecoder", (String)"printStackTrace", (Throwable)e);
            }
            if (n < this.blockSize) {
                this.status = 1;
            }
        }
        return n;
    }

    protected int[] readColorTable(int ncolors) {
        int nbytes = 3 * ncolors;
        int[] tab = null;
        byte[] c = new byte[nbytes];
        int n = 0;
        try {
            n = this.in.read(c);
        }
        catch (Exception e) {
            Log.e((String)"GifDecoder", (String)"printStackTrace", (Throwable)e);
        }
        if (n < nbytes) {
            this.status = 1;
        } else {
            tab = new int[256];
            int i = 0;
            int j = 0;
            while (i < ncolors) {
                int r = c[j++] & 0xFF;
                int g = c[j++] & 0xFF;
                int b = c[j++] & 0xFF;
                tab[i++] = 0xFF000000 | r << 16 | g << 8 | b;
            }
        }
        return tab;
    }

    protected void readContents() {
        boolean done = false;
        block11: while (!done && !this.err()) {
            int code = this.read();
            switch (code) {
                case 44: {
                    this.readBitmap();
                    continue block11;
                }
                case 33: {
                    code = this.read();
                    switch (code) {
                        case 249: {
                            this.readGraphicControlExt();
                            continue block11;
                        }
                        case 255: {
                            this.readBlock();
                            String app = "";
                            for (int i = 0; i < 11; ++i) {
                                app = app + (char)this.block[i];
                            }
                            if (app.equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                continue block11;
                            }
                            this.skip();
                            continue block11;
                        }
                        case 254: {
                            this.skip();
                            continue block11;
                        }
                        case 1: {
                            this.skip();
                            continue block11;
                        }
                    }
                    this.skip();
                    continue block11;
                }
                case 59: {
                    done = true;
                    continue block11;
                }
            }
            this.status = 1;
        }
    }

    protected void readGraphicControlExt() {
        this.read();
        int packed = this.read();
        this.dispose = (packed & 0x1C) >> 2;
        if (this.dispose == 0) {
            this.dispose = 1;
        }
        this.transparency = (packed & 1) != 0;
        this.delay = this.readShort() * 10;
        this.transIndex = this.read();
        this.read();
    }

    protected void readHeader() {
        String id2 = "";
        for (int i = 0; i < 6; ++i) {
            id2 = id2 + (char)this.read();
        }
        if (!id2.startsWith("GIF")) {
            this.status = 1;
            return;
        }
        this.readLSD();
        if (this.gctFlag && !this.err()) {
            this.gct = this.readColorTable(this.gctSize);
            this.bgColor = this.gct[this.bgIndex];
        }
    }

    protected void readBitmap() {
        this.ix = this.readShort();
        this.iy = this.readShort();
        this.iw = this.readShort();
        this.ih = this.readShort();
        int packed = this.read();
        this.lctFlag = (packed & 0x80) != 0;
        this.lctSize = (int)Math.pow(2.0, (packed & 7) + 1);
        boolean bl = this.interlace = (packed & 0x40) != 0;
        if (this.lctFlag) {
            this.lct = this.readColorTable(this.lctSize);
            this.act = this.lct;
        } else {
            this.act = this.gct;
            if (this.bgIndex == this.transIndex) {
                this.bgColor = 0;
            }
        }
        int save = 0;
        if (this.transparency) {
            save = this.act[this.transIndex];
            this.act[this.transIndex] = 0;
        }
        if (this.act == null) {
            this.status = 1;
        }
        if (this.err()) {
            return;
        }
        this.decodeBitmapData();
        this.skip();
        if (this.err()) {
            return;
        }
        ++this.frameCount;
        this.image = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        this.setPixels();
        this.frames.addElement(new GifFrame(this.image, this.delay));
        if (this.transparency) {
            this.act[this.transIndex] = save;
        }
        this.resetFrame();
    }

    protected void readLSD() {
        this.width = this.readShort();
        this.height = this.readShort();
        int packed = this.read();
        this.gctFlag = (packed & 0x80) != 0;
        this.gctSize = 2 << (packed & 7);
        this.bgIndex = this.read();
        this.pixelAspect = this.read();
    }

    protected void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            int b1 = this.block[1] & 0xFF;
            int b2 = this.block[2] & 0xFF;
            this.loopCount = b2 << 8 | b1;
        } while (this.blockSize > 0 && !this.err());
    }

    protected int readShort() {
        return this.read() | this.read() << 8;
    }

    protected void resetFrame() {
        this.lastDispose = this.dispose;
        this.lrx = this.ix;
        this.lry = this.iy;
        this.lrw = this.iw;
        this.lrh = this.ih;
        this.lastBitmap = this.image;
        this.lastBgColor = this.bgColor;
        this.dispose = 0;
        this.transparency = false;
        this.delay = 0;
        this.lct = null;
    }

    protected void skip() {
        do {
            this.readBlock();
        } while (this.blockSize > 0 && !this.err());
    }

    private static class GifFrame {
        public Bitmap image;
        public int delay;

        public GifFrame(Bitmap im, int del) {
            this.image = im;
            this.delay = del;
        }
    }
}

