/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.gif;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.gif.GifDecoder;
import com.yy.mobile.util.log.MLog;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class AnimatedGifDrawable
extends AnimationDrawable {
    private static final String TAG = "AnimatedGifDrawable";
    private int mCurrentIndex = 0;
    private UpdateListener mListener;
    private ArrayList<Drawable> mDrawableList = new ArrayList();
    private SafeDispatchHandler mHandler = new SafeDispatchHandler();

    public SafeDispatchHandler getHandler() {
        return this.mHandler;
    }

    public void stop() {
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public AnimatedGifDrawable(String source, UpdateListener listener) {
        this.mListener = listener;
        GifDecoder decoder = new GifDecoder();
        try {
            decoder.read(new FileInputStream(source));
        }
        catch (FileNotFoundException e) {
            MLog.error(TAG, e);
            return;
        }
        for (int i = 0; i < decoder.getFrameCount(); ++i) {
            Bitmap bitmap = decoder.getFrame(i);
            BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
            drawable2.setBounds(0, 0, bitmap.getWidth(), bitmap.getHeight());
            this.addFrame((Drawable)drawable2, decoder.getDelay(i));
            this.mDrawableList.add((Drawable)drawable2);
        }
    }

    public void nextFrame() {
        int count = this.getNumberOfFrames();
        if (count <= 0) {
            return;
        }
        this.mCurrentIndex = (this.mCurrentIndex + 1) % this.getNumberOfFrames();
        if (this.mListener != null) {
            this.mListener.update();
        }
    }

    public int getFrameDuration() {
        return this.getDuration(this.mCurrentIndex);
    }

    public Drawable getDrawable() {
        return this.getFrame(this.mCurrentIndex);
    }

    protected void onBoundsChange(Rect bounds) {
        for (Drawable drawable2 : this.mDrawableList) {
            drawable2.setBounds(bounds);
        }
    }

    public static interface UpdateListener {
        public void update();
    }
}

