/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.view.Window;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.log.MLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Method;

public final class SystemUtils {
    public static final String TAG = "SystemUtils";

    public static boolean isMainThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    public static void fixMediaSessionLegacyHelper() {
        try {
            if (Build.VERSION.SDK_INT != 21) {
                MLog.info(TAG, "fixMediaSessionLegacyHelper api:" + Build.VERSION.SDK_INT, new Object[0]);
                return;
            }
            Class<?> cls = Class.forName("android.media.session.MediaSessionLegacyHelper");
            if (cls == null) {
                return;
            }
            Method method = cls.getMethod("getHelper", Context.class);
            method.invoke(null, BasicConfig.getInstance().getAppContext());
            MLog.info(TAG, "fixMediaSessionLegacyHelper done!", new Object[0]);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, "fixMediaSessionLegacyHelper error! " + throwable, new Object[0]);
        }
    }

    public static boolean isRoot() {
        String binPath = "/system/bin/su";
        String xBinPath = "/system/xbin/su";
        boolean isRooted = false;
        try {
            isRooted = new File(binPath).exists() && SystemUtils.isExecutable(binPath) || new File(xBinPath).exists() && SystemUtils.isExecutable(xBinPath);
        }
        catch (Throwable e) {
            isRooted = false;
        }
        return isRooted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isExecutable(String filePath) {
        Process p = null;
        try {
            char flag;
            p = Runtime.getRuntime().exec("ls -l " + filePath);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String str = in.readLine();
            if (str != null && str.length() >= 4 && ((flag = str.charAt(3)) == 's' || flag == 'x')) {
                boolean bl = true;
                return bl;
            }
            in.close();
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, "isExecutable failed", throwable, new Object[0]);
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
        return false;
    }

    @TargetApi(value=19)
    public static void setTranslucentStatus(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.clearFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(1280);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
        } else if (Build.VERSION.SDK_INT >= 19) {
            Window window = activity.getWindow();
            window.setFlags(0x4000000, 0x4000000);
        }
    }
}

