/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewConfiguration;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ScreenUtil {
    public static final int DENSITY_DEFAULT = 160;
    public static final int SCREEN_SIZE_Y_LARGE = 640;
    private DisplayMetrics mDM = BasicConfig.getInstance().getAppContext().getResources().getDisplayMetrics();
    private float mDensity = 0.0f;
    private int mWidthPixels = 0;
    private int mHeightPixels = 0;
    private int mWindowWidthPixels = 0;
    private int mWindowHeightPixels = 0;
    private static int mStatusBarHeight = 0;
    private static ScreenUtil mInstance = null;

    private ScreenUtil() {
        this.mDensity = this.mDM.density;
        this.mWidthPixels = Math.min(this.mDM.widthPixels, this.mDM.heightPixels);
        this.mHeightPixels = Math.max(this.mDM.widthPixels, this.mDM.heightPixels);
    }

    public static ScreenUtil getInstance() {
        if (mInstance == null) {
            mInstance = new ScreenUtil();
        }
        return mInstance;
    }

    public void init(Activity activity) {
        if (activity == null) {
            return;
        }
        this.mWindowWidthPixels = this.getWindowWidth(activity);
        this.mWindowHeightPixels = this.getWindowHeight(activity);
        mStatusBarHeight = this.getStatusBarHeightInner(activity);
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.mDM;
    }

    public float getDensity() {
        return this.mDensity;
    }

    public int getWidthPixels() {
        return this.mWidthPixels;
    }

    public int getHeightPixels() {
        return this.mHeightPixels;
    }

    public static int getStatusBarHeight() {
        block4: {
            try {
                if (mStatusBarHeight == 0) {
                    int result = 0;
                    int resourceId = Resources.getSystem().getIdentifier("status_bar_height", "dimen", "android");
                    if (resourceId > 0) {
                        result = Resources.getSystem().getDimensionPixelSize(resourceId);
                    }
                    mStatusBarHeight = result;
                    return mStatusBarHeight;
                }
            }
            catch (Throwable e) {
                MLog.error((Object)"ScreenUtil", "gg getStatusBarHeight" + e, new Object[0]);
                Activity activity = YYActivityManager.INSTANCE.getCurrentActivity();
                if (activity == null) break block4;
                new ScreenUtil().getStatusBarHeightInner(activity);
            }
        }
        return mStatusBarHeight;
    }

    public int getWindowWidthPixels() {
        return this.mWindowWidthPixels;
    }

    public int getWindowHeightPixels() {
        return this.mWindowHeightPixels;
    }

    public int dip2px(int dip) {
        return (int)(0.5f + this.mDensity * (float)dip);
    }

    public int px2dip(int px) {
        return (int)(0.5f + (float)px / this.mDensity);
    }

    public int dip2px(float dip) {
        return (int)(0.5f + this.mDensity * dip);
    }

    public int px2dip(float px) {
        return (int)(0.5f + px / this.mDensity);
    }

    public int percentHeight(float percent) {
        return (int)(percent * (float)this.getHeightPixels());
    }

    public int percentWidth(float percent) {
        return (int)(percent * (float)this.getWidthPixels());
    }

    private int getStatusBarHeightInner(Activity activity) {
        if (activity == null) {
            return 0;
        }
        int statusBarHeight = 0;
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object obj = c.newInstance();
            Field field = c.getField("status_bar_height");
            int x = Integer.parseInt(field.get(obj).toString());
            statusBarHeight = activity.getResources().getDimensionPixelSize(x);
        }
        catch (Exception e) {
            Rect rect = new Rect();
            activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
            statusBarHeight = rect.top;
        }
        return statusBarHeight;
    }

    private int getWindowWidth(Activity activity) {
        View decor = activity.getWindow().getDecorView();
        return decor.getMeasuredWidth();
    }

    private int getWindowHeight(Activity activity) {
        View decor = activity.getWindow().getDecorView();
        return decor.getMeasuredHeight();
    }

    public static boolean isFullScreen() {
        return BasicConfig.getInstance().getAppContext().getResources().getConfiguration().orientation == 2;
    }

    @Deprecated
    public static int getNavigationBarHeight() {
        Resources res;
        int resourceId;
        int result = 0;
        if (ScreenUtil.hasNavBar(BasicConfig.getInstance().getAppContext()) && (resourceId = (res = BasicConfig.getInstance().getAppContext().getResources()).getIdentifier("navigation_bar_height", "dimen", "android")) > 0) {
            result = res.getDimensionPixelSize(resourceId);
        }
        MLog.info("ScreenUtil", "getNavigationBarHeight %d", result);
        return result;
    }

    public static boolean hasNavBar(Context context) {
        Resources res = context.getResources();
        int resourceId = res.getIdentifier("config_showNavigationBar", "bool", "android");
        if (resourceId != 0) {
            boolean hasNav = res.getBoolean(resourceId);
            String sNavBarOverride = ScreenUtil.getNavBarOverride();
            if ("1".equals(sNavBarOverride)) {
                hasNav = false;
            } else if ("0".equals(sNavBarOverride)) {
                hasNav = true;
            }
            return hasNav;
        }
        return !ViewConfiguration.get((Context)context).hasPermanentMenuKey();
    }

    public static String getNavBarOverride() {
        String sNavBarOverride = null;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method m = c.getDeclaredMethod("get", String.class);
                m.setAccessible(true);
                sNavBarOverride = (String)m.invoke(null, "qemu.hw.mainkeys");
            }
            catch (Throwable e) {
                MLog.error((Object)"ScreenUtil", "", e, new Object[0]);
            }
        }
        return sNavBarOverride;
    }
}

