/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.util.Log;
import android.util.Printer;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.log.MLog;
import java.text.SimpleDateFormat;

public class LoggingStopWatch {
    private static final String TAG = "LoggingStopWatch";
    private static final int STATE_UNSTARTED = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_STOPPED = 2;
    private static final int STATE_SUSPENDED = 3;
    private int runningState = 0;
    private long startTime = -1L;
    private long stopTime = -1L;
    private long lastSpiltTime = -1L;
    private String name;
    private Printer mLogging;

    public LoggingStopWatch(String name) {
        this.name = name;
    }

    public void setPrinter(Printer printer) {
        this.mLogging = printer;
    }

    public void start() {
        if (this.runningState == 2) {
            Log.w((String)TAG, (String)"Stopwatch must be reset before being restarted. ");
        }
        if (this.runningState != 0) {
            Log.w((String)TAG, (String)"Stopwatch already started. ");
        }
        this.stopTime = -1L;
        this.lastSpiltTime = this.startTime = System.currentTimeMillis();
        this.runningState = 1;
        if (this.mLogging != null) {
            this.mLogging.println("start stopwatch [" + this.name + "]");
        }
    }

    public void stop() {
        if (this.runningState != 1 && this.runningState != 3) {
            Log.w((String)TAG, (String)"Stopwatch is not running. ");
        }
        if (this.runningState == 1) {
            this.stopTime = System.currentTimeMillis();
        }
        this.runningState = 2;
        if (this.mLogging != null) {
            this.mLogging.println("stop stopwatch [" + this.name + "] " + (this.stopTime - this.lastSpiltTime) + "/" + this.getSplitTime());
        }
    }

    public void reset() {
        this.runningState = 0;
        this.startTime = -1L;
        this.stopTime = -1L;
    }

    public void split(String tag) {
        if (this.runningState != 1) {
            Log.w((String)TAG, (String)"Stopwatch is not running. ");
            return;
        }
        this.stopTime = System.currentTimeMillis();
        MLog.info("TimeCount", "split [" + this.name + "][" + tag + "] " + (this.stopTime - this.lastSpiltTime) + "/" + this.getSplitTime(), new Object[0]);
        this.lastSpiltTime = this.stopTime;
    }

    public void suspend() {
        if (this.runningState != 1) {
            Log.w((String)TAG, (String)"Stopwatch must be running to suspend. ");
            return;
        }
        this.stopTime = System.currentTimeMillis();
        this.runningState = 3;
    }

    public void resume() {
        if (this.runningState != 3) {
            Log.w((String)TAG, (String)"Stopwatch must be suspended to resume. ");
        }
        this.startTime += System.currentTimeMillis() - this.stopTime;
        this.stopTime = -1L;
        this.runningState = 1;
    }

    public long getTime() {
        if (this.runningState == 2 || this.runningState == 3) {
            return this.stopTime - this.startTime;
        }
        if (this.runningState == 0) {
            return 0L;
        }
        if (this.runningState == 1) {
            return System.currentTimeMillis() - this.startTime;
        }
        Log.e((String)TAG, (String)"Illegal running state has occurred. ");
        return -1L;
    }

    public long getSplitTime() {
        return this.stopTime - this.startTime;
    }

    public long getStartTime() {
        if (this.runningState == 0) {
            Log.w((String)TAG, (String)"Stopwatch has not been started");
            return -1L;
        }
        return this.startTime;
    }

    public String toString() {
        SimpleDateFormat format = CommonUtils.getSimpleDateFormat("mm:ss:SSS");
        long time = this.getTime();
        if (time <= 0L) {
            return "";
        }
        return format.format(this.getTime());
    }

    private static String formatTime(long ms) {
        if (ms <= 0L) {
            return "00:00:000";
        }
        long minutes = ms / 60000L;
        long seconds = (ms - minutes * 60L * 1000L) / 1000L;
        long mi = ms % 1000L;
        return String.format("%02d:%02d:%03d", minutes, seconds, mi);
    }

    public String toSplitString() {
        return LoggingStopWatch.formatTime(this.getSplitTime());
    }
}

