/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.MD5Utils;
import com.yy.mobile.util.SpdtDeviceInfo;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import java.text.SimpleDateFormat;
import java.util.HashMap;

public class CommonUtils {
    private static long lastClickTime;
    private static HashMap<String, SimpleDateFormat> mSimpleDateFormatCache;

    public static boolean isCurrentMainThread() {
        return Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId();
    }

    public static String getImei(Context c) {
        TelephonyManager manager;
        String imei;
        if (((SpdtDeviceInfo)Spdt.of(SpdtDeviceInfo.class)).enableImei() && !BlankUtil.isBlank(imei = (manager = (TelephonyManager)c.getSystemService("phone")).getDeviceId()) && !imei.matches("0+") && !imei.equals("004999010640000")) {
            return MD5Utils.getDoubleMD5String(imei);
        }
        return "";
    }

    public static boolean isFastClick(long timeThreshold) {
        long time = System.currentTimeMillis();
        if (time - lastClickTime < timeThreshold) {
            return true;
        }
        lastClickTime = time;
        return false;
    }

    public static void setGLSurfaceViewThreadName(String name) {
        if (name == null) {
            return;
        }
        try {
            Thread currentThread = Thread.currentThread();
            String threadName = currentThread.getName();
            if (threadName != null && threadName.startsWith("GLThread ")) {
                currentThread.setName(name);
            }
        }
        catch (Throwable e) {
            Log.e((String)"CommonUtils", (String)"Empty Catch on setGLSurfaceViewThreadName", (Throwable)e);
        }
    }

    public static SimpleDateFormat getSimpleDateFormat(String format) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            SimpleDateFormat sdf = mSimpleDateFormatCache.get(format);
            if (sdf == null) {
                sdf = new SimpleDateFormat(format);
                mSimpleDateFormatCache.put(format, sdf);
            }
            return sdf;
        }
        return new SimpleDateFormat(format);
    }

    public static int getAvailMemory() {
        int availMem = 0;
        try {
            ActivityManager.MemoryInfo mem = new ActivityManager.MemoryInfo();
            ActivityManager activityManager = (ActivityManager)BasicConfig.getInstance().getAppContext().getSystemService("activity");
            activityManager.getMemoryInfo(mem);
            availMem = (int)(mem.availMem / 1024L);
        }
        catch (Throwable e) {
            MLog.error((Object)"CommonUtils", "getTotalMemory()" + e.toString(), new Object[0]);
        }
        return availMem;
    }

    public static int getTotalMemory() {
        int availMem = -1;
        try {
            ActivityManager.MemoryInfo mem = new ActivityManager.MemoryInfo();
            ActivityManager activityManager = (ActivityManager)BasicConfig.getInstance().getAppContext().getSystemService("activity");
            activityManager.getMemoryInfo(mem);
            availMem = Build.VERSION.SDK_INT < 16 ? 1024 : (int)(mem.totalMem >>> 20);
        }
        catch (Throwable e) {
            MLog.error((Object)"CommonUtils", "getTotalMemory()" + e.toString(), new Object[0]);
        }
        return availMem;
    }

    public static boolean isAppInstalled(Context context, String pkgName) {
        return false;
    }

    static {
        mSimpleDateFormatCache = new HashMap();
    }
}

