/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.toast;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u001c\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/yy/mobile/ui/widget/toast/ToastCompat;", "Landroid/widget/Toast;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "TAG", "", "getDeclaredField", "Ljava/lang/reflect/Field;", "obj", "", "fieldName", "getFieldValue", "field", "setFieldValue", "", "object", "newFieldValue", "show", "", "tryToHook", "Companion", "InternalHandlerCallback", "framework_release"})
public final class ToastCompat
extends Toast {
    private final String TAG = "ToastCompat";
    public static final Companion Companion = new Companion(null);

    public void show() {
        if (ToastCompat.Companion.needHook()) {
            this.tryToHook();
        }
        super.show();
    }

    private final void tryToHook() {
        try {
            Object mTN = this.getFieldValue((Object)this, "mTN");
            if (mTN != null) {
                boolean isSuccess = false;
                Object rawHandler = this.getFieldValue(mTN, "mHandler");
                if (rawHandler != null && rawHandler instanceof Handler) {
                    isSuccess = this.setFieldValue(rawHandler, "mCallback", new InternalHandlerCallback((Handler)rawHandler));
                }
                if (!isSuccess) {
                    Log.e((String)this.TAG, (String)"tryToHook Toast error.");
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private final boolean setFieldValue(Object object, String fieldName, Object newFieldValue) {
        Field field = this.getDeclaredField(object, fieldName);
        if (field != null) {
            try {
                int accessFlags = field.getModifiers();
                if (Modifier.isFinal(accessFlags)) {
                    Field modifiersField;
                    Field field2 = modifiersField = Field.class.getDeclaredField("accessFlags");
                    Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"modifiersField");
                    field2.setAccessible(true);
                    modifiersField.setInt(field, field.getModifiers() & ~16);
                }
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(object, newFieldValue);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private final Object getFieldValue(Object obj, String fieldName) {
        Field field = this.getDeclaredField(obj, fieldName);
        return this.getFieldValue(obj, field);
    }

    private final Object getFieldValue(Object obj, Field field) {
        if (field != null) {
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field.get(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private final Field getDeclaredField(Object obj, String fieldName) {
        Class<?> superClass = obj.getClass();
        while (Intrinsics.areEqual(superClass, Object.class) ^ true) {
            try {
                return superClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if (superClass.getSuperclass() != null) continue;
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<kotlin.Any>");
            }
        }
        return null;
    }

    public ToastCompat(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.TAG = "ToastCompat";
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/yy/mobile/ui/widget/toast/ToastCompat$InternalHandlerCallback;", "Landroid/os/Handler$Callback;", "mHandler", "Landroid/os/Handler;", "(Lcom/yy/mobile/ui/widget/toast/ToastCompat;Landroid/os/Handler;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "framework_release"})
    private final class InternalHandlerCallback
    implements Handler.Callback {
        private final Handler mHandler;

        public boolean handleMessage(@NotNull Message msg) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            try {
                this.mHandler.handleMessage(msg);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return true;
        }

        public InternalHandlerCallback(Handler mHandler) {
            Intrinsics.checkParameterIsNotNull((Object)mHandler, (String)"mHandler");
            this.mHandler = mHandler;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/yy/mobile/ui/widget/toast/ToastCompat$Companion;", "", "()V", "makeText", "Landroid/widget/Toast;", "context", "Landroid/content/Context;", "text", "", "duration", "", "resId", "needHook", "", "framework_release"})
    public static final class Companion {
        @NotNull
        public final Toast makeText(@NotNull Context context, @NotNull CharSequence text, int duration) {
            Toast toast;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            if (this.needHook()) {
                Object object = context.getSystemService("layout_inflater");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.view.LayoutInflater");
                }
                LayoutInflater inflate = (LayoutInflater)object;
                Resources resources = context.getResources();
                View v = inflate.inflate(resources.getIdentifier("transient_notification", "layout", "android"), null);
                View view = v.findViewById(resources.getIdentifier("message", "id", "android"));
                if (view == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
                }
                TextView tv = (TextView)view;
                tv.setText(text);
                ToastCompat toastCompat = new ToastCompat(context);
                toastCompat.setView(v);
                toastCompat.setDuration(duration);
                toast = toastCompat;
            } else {
                Toast toast2 = Toast.makeText((Context)context, (CharSequence)text, (int)duration);
                toast = toast2;
                Intrinsics.checkExpressionValueIsNotNull((Object)toast2, (String)"Toast.makeText(context, text, duration)");
            }
            return toast;
        }

        @NotNull
        public final Toast makeText(@NotNull Context context, int resId, int duration) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            CharSequence charSequence = context.getResources().getText(resId);
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"context.resources.getText(resId)");
            return this.makeText(context, charSequence, duration);
        }

        private final boolean needHook() {
            return Build.VERSION.SDK_INT >= 25;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

