/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.labelView;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.framework.R;
import com.yy.mobile.ui.widget.labelView.Label;
import com.yy.mobile.ui.widget.labelView.LabelUtils;
import com.yy.mobile.util.ResolutionUtils;
import java.util.ArrayList;
import java.util.List;

public class LabelView
extends RelativeLayout {
    private List<Label> mLabels = new ArrayList<Label>();
    private LayoutInflater mInflater;
    private ViewTreeObserver mViewTreeObserber;
    private OnLabelClickListener mClickListener;
    private OnLabelDeleteListener mDeleteListener;
    private int mWidth;
    private int mLimitRows = 0;
    private boolean mInitialized = false;
    int lineMargin;
    int labelMargin;
    int textPaddingLeft;
    int textPaddingRight;
    int textPaddingTop;
    int texPaddingBottom;

    public void setOnLabelClickListener(OnLabelClickListener clickListener) {
        this.mClickListener = clickListener;
    }

    public void setOnLabelDeleteListener(OnLabelDeleteListener deleteListener) {
        this.mDeleteListener = deleteListener;
    }

    public LabelView(Context ctx) {
        super(ctx, null);
        this.initialize(ctx, null, 0);
    }

    public LabelView(Context ctx, AttributeSet attrs) {
        super(ctx, attrs);
        this.initialize(ctx, attrs, 0);
    }

    public LabelView(Context ctx, AttributeSet attrs, int defStyle) {
        super(ctx, attrs, defStyle);
        this.initialize(ctx, attrs, defStyle);
    }

    private void initialize(Context ctx, AttributeSet attrs, int defStyle) {
        this.mInflater = (LayoutInflater)ctx.getSystemService("layout_inflater");
        this.mViewTreeObserber = this.getViewTreeObserver();
        this.mViewTreeObserber.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (!LabelView.this.mInitialized) {
                    LabelView.this.mInitialized = true;
                    LabelView.this.drawTags();
                }
            }
        });
        TypedArray typeArray = ctx.obtainStyledAttributes(attrs, R.styleable.LabelView, defStyle, defStyle);
        this.lineMargin = (int)typeArray.getDimension(R.styleable.LabelView_labelLineMargin, (float)LabelUtils.dipToPx(this.getContext(), 5.0f));
        this.labelMargin = (int)typeArray.getDimension(R.styleable.LabelView_labelMargin, (float)LabelUtils.dipToPx(this.getContext(), 5.0f));
        this.textPaddingLeft = (int)this.getContext().getResources().getDimension(R.dimen.hot_words_label_offset);
        this.textPaddingRight = (int)this.getContext().getResources().getDimension(R.dimen.hot_words_text_padding);
        this.textPaddingTop = (int)typeArray.getDimension(R.styleable.LabelView_labelTextPaddingTop, (float)LabelUtils.dipToPx(this.getContext(), 5.0f));
        this.texPaddingBottom = (int)typeArray.getDimension(R.styleable.LabelView_labelTextPaddingBottom, (float)LabelUtils.dipToPx(this.getContext(), 5.0f));
        this.mWidth = ResolutionUtils.getScreenWidth(ctx) - (int)typeArray.getDimension(R.styleable.LabelView_labelInitWidthReserved, (float)LabelUtils.dipToPx(ctx, 20.0f));
        typeArray.recycle();
        this.drawTags();
    }

    public void setLayoutWidth(int width) {
        this.mWidth = width;
    }

    @Deprecated
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mWidth = w;
    }

    @SuppressLint(value={"InflateParams"})
    private void drawTags() {
        if (!this.mInitialized) {
            return;
        }
        this.removeAllViews();
        float total = this.getPaddingLeft() + this.getPaddingRight();
        int listRow = 1;
        int listIndex = 1;
        int indexBottom = 1;
        int indexHeader = 1;
        Label labelPre = null;
        for (Label item : this.mLabels) {
            final int position = listIndex - 1;
            final Label label = item;
            LinearLayout root = new LinearLayout(this.getContext());
            root.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
            View labelLayout = this.mInflater.inflate(R.layout.item_label_view, (ViewGroup)root);
            labelLayout.setId(listIndex);
            TextView labelView = (TextView)labelLayout.findViewById(R.id.tv_label_item_contain);
            labelView.setText((CharSequence)label.text);
            labelView.setPadding(this.textPaddingLeft, this.textPaddingTop, this.textPaddingRight, this.texPaddingBottom);
            labelView.setTextColor(label.tagTextColor);
            if (label.layoutBgRes > 0) {
                labelView.setBackgroundResource(label.layoutBgRes);
            }
            if (label.tagTextSize > 0.0f) {
                labelView.setTextSize(label.tagTextSize);
            }
            labelLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (LabelView.this.mClickListener != null) {
                        LabelView.this.mClickListener.onLabelClick(label, position);
                    }
                }
            });
            float labelText = 0.0f;
            if (label.text != null && !label.text.isEmpty()) {
                labelText = labelView.getPaint().measureText(label.text);
            }
            float labelWidth = labelText + (float)this.textPaddingLeft + (float)this.textPaddingRight;
            TextView deletableView = (TextView)labelLayout.findViewById(R.id.tv_label_item_delete);
            if (label.isDeletable) {
                deletableView.setVisibility(0);
                deletableView.setText((CharSequence)label.deleteIcon);
                deletableView.setPadding(0, this.textPaddingTop, this.textPaddingRight, this.texPaddingBottom);
                deletableView.setTextColor(label.deleteIndicatorColor);
                deletableView.setTextSize((float)LabelUtils.spToPx(this.getContext(), label.deleteIndicatorSize));
                deletableView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        LabelView.this.remove(position);
                        if (LabelView.this.mDeleteListener != null) {
                            Label targetLabel = label;
                            LabelView.this.mDeleteListener.onLabelDeleted(targetLabel, position);
                        }
                    }
                });
                labelWidth += deletableView.getPaint().measureText(label.deleteIcon) + (float)this.textPaddingLeft + (float)this.textPaddingRight;
            } else {
                deletableView.setVisibility(8);
            }
            RelativeLayout.LayoutParams labelParams = new RelativeLayout.LayoutParams(-2, -2);
            labelParams.bottomMargin = this.lineMargin;
            if ((float)this.mWidth < total + labelWidth + (float)this.labelMargin) {
                if (++listRow > this.mLimitRows) break;
                labelParams.addRule(3, indexBottom);
                total = this.getPaddingLeft() + this.getPaddingRight();
                indexBottom = listIndex;
                indexHeader = listIndex;
            } else {
                labelParams.addRule(6, indexHeader);
                if (listIndex != indexHeader) {
                    labelParams.addRule(1, listIndex - 1);
                    labelParams.leftMargin = this.labelMargin;
                    total += (float)this.labelMargin;
                    if (labelPre != null && labelPre.tagTextSize < label.tagTextSize) {
                        indexBottom = listIndex;
                    }
                }
            }
            total += labelWidth;
            this.addView(labelLayout, (ViewGroup.LayoutParams)labelParams);
            labelPre = label;
            ++listIndex;
        }
    }

    public void add(Label label) {
        this.mLabels.add(label);
        this.drawTags();
    }

    public void addAll(List<Label> labelList) {
        this.mLabels.addAll(labelList);
        this.drawTags();
    }

    public List<Label> getTags() {
        return this.mLabels;
    }

    public void remove(int position) {
        this.mLabels.remove(position);
        this.drawTags();
    }

    public void clearAllLabels() {
        this.mLabels.clear();
        this.removeAllViews();
    }

    public int getLineMargin() {
        return this.lineMargin;
    }

    public void setLineMargin(float lineMargin) {
        this.lineMargin = LabelUtils.dipToPx(this.getContext(), lineMargin);
    }

    public int getLabelMargin() {
        return this.labelMargin;
    }

    public void setLabelMargin(float tagMargin) {
        this.labelMargin = LabelUtils.dipToPx(this.getContext(), tagMargin);
    }

    public int getTextPaddingLeft() {
        return this.textPaddingLeft;
    }

    public void setTextPaddingLeft(float textPaddingLeft) {
        this.textPaddingLeft = LabelUtils.dipToPx(this.getContext(), textPaddingLeft);
    }

    public int getTextPaddingRight() {
        return this.textPaddingRight;
    }

    public void setTextPaddingRight(float textPaddingRight) {
        this.textPaddingRight = LabelUtils.dipToPx(this.getContext(), textPaddingRight);
    }

    public int getTextPaddingTop() {
        return this.textPaddingTop;
    }

    public void setTextPaddingTop(float textPaddingTop) {
        this.textPaddingTop = LabelUtils.dipToPx(this.getContext(), textPaddingTop);
    }

    public int getTexPaddingBottom() {
        return this.texPaddingBottom;
    }

    public void setTexPaddingBottom(float texPaddingBottom) {
        this.texPaddingBottom = LabelUtils.dipToPx(this.getContext(), texPaddingBottom);
    }

    public void setLimitRows(int limitRow) {
        this.mLimitRows = limitRow;
    }

    public int getLimitRows() {
        return this.mLimitRows;
    }

    public static interface OnLabelDeleteListener {
        public void onLabelDeleted(Label var1, int var2);
    }

    public static interface OnLabelClickListener {
        public void onLabelClick(Label var1, int var2);
    }
}

