/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.headerviewpager;

import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import com.yy.mobile.ui.widget.headerviewpager.ViewDelegate;

public class AbsListViewDelegate
implements ViewDelegate<AbsListView> {
    private final int[] mViewLocationResult = new int[2];
    private final Rect mRect = new Rect();

    @Override
    public boolean isViewBeingDragged(MotionEvent event, AbsListView view) {
        if (view.getAdapter() == null || ((ListAdapter)view.getAdapter()).isEmpty()) {
            return true;
        }
        view.getLocationOnScreen(this.mViewLocationResult);
        int viewLeft = this.mViewLocationResult[0];
        int viewTop = this.mViewLocationResult[1];
        this.mRect.set(viewLeft, viewTop, viewLeft + view.getWidth(), viewTop + view.getHeight());
        int rawX = (int)event.getRawX();
        int rawY = (int)event.getRawY();
        if (this.mRect.contains(rawX, rawY)) {
            return this.isReadyForPull(view, (float)(rawX - this.mRect.left), (float)(rawY - this.mRect.top));
        }
        return false;
    }

    @Override
    public boolean isReadyForPull(AbsListView view, float x, float y) {
        boolean ready = false;
        if (view.getCount() == 0) {
            ready = true;
        } else if (view.getFirstVisiblePosition() == 0) {
            View firstVisibleChild = view.getChildAt(0);
            ready = firstVisibleChild != null && firstVisibleChild.getTop() >= view.getPaddingTop();
        }
        return ready;
    }
}

