/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.datetimepicker;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import android.view.View;
import com.yy.mobile.framework.R;

public class CircleView
extends View {
    private static final String TAG = "CircleView";
    private final Paint mPaint = new Paint();
    private boolean mIs24HourMode;
    private int mWhite;
    private int mBlack;
    private float mCircleRadiusMultiplier;
    private float mAmPmCircleRadiusMultiplier;
    private boolean mIsInitialized;
    private boolean mDrawValuesReady;
    private int mXCenter;
    private int mYCenter;
    private int mCircleRadius;

    public CircleView(Context context) {
        super(context);
        Resources res = context.getResources();
        this.mWhite = res.getColor(R.color.white);
        this.mBlack = res.getColor(R.color.numbers_text_color);
        this.mPaint.setAntiAlias(true);
        this.mIsInitialized = false;
    }

    public void initialize(Context context, boolean is24HourMode) {
        if (this.mIsInitialized) {
            Log.e((String)TAG, (String)"CircleView may only be initialized once.");
            return;
        }
        Resources res = context.getResources();
        this.mIs24HourMode = is24HourMode;
        if (is24HourMode) {
            this.mCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.circle_radius_multiplier_24HourMode));
        } else {
            this.mCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.circle_radius_multiplier));
            this.mAmPmCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.ampm_circle_radius_multiplier));
        }
        this.mIsInitialized = true;
    }

    public void onDraw(Canvas canvas) {
        int viewWidth = this.getWidth();
        if (viewWidth == 0 || !this.mIsInitialized) {
            return;
        }
        if (!this.mDrawValuesReady) {
            this.mXCenter = this.getWidth() / 2;
            this.mYCenter = this.getHeight() / 2;
            this.mCircleRadius = (int)((float)Math.min(this.mXCenter, this.mYCenter) * this.mCircleRadiusMultiplier);
            if (!this.mIs24HourMode) {
                int amPmCircleRadius = (int)((float)this.mCircleRadius * this.mAmPmCircleRadiusMultiplier);
                this.mYCenter -= amPmCircleRadius / 2;
            }
            this.mDrawValuesReady = true;
        }
        this.mPaint.setColor(this.mWhite);
        canvas.drawCircle((float)this.mXCenter, (float)this.mYCenter, (float)this.mCircleRadius, this.mPaint);
        this.mPaint.setColor(this.mBlack);
        canvas.drawCircle((float)this.mXCenter, (float)this.mYCenter, 2.0f, this.mPaint);
    }
}

