/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.bubblelayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.widget.FrameLayout;
import com.yy.mobile.framework.R;
import com.yy.mobile.ui.widget.bubblelayout.ArrowDirection;
import com.yy.mobile.ui.widget.bubblelayout.Bubble;

public class BubbleLayout
extends FrameLayout {
    public static float DEFAULT_STROKE_WIDTH = -1.0f;
    private ArrowDirection mArrowDirection;
    private Bubble mBubble;
    private float mArrowWidth;
    private float mCornersRadius;
    private float mArrowHeight;
    private float mArrowPosition;
    private int mBubbleColor;
    private float mStrokeWidth;
    private int mStrokeColor;
    private int bubblePaddingLeft;
    private int bubblePaddingRight;
    private int bubblePaddingTop;
    private int bubblePaddingBottom;

    public BubbleLayout(Context context) {
        this(context, null, 0);
    }

    public BubbleLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BubbleLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BubbleLayout);
        this.mArrowWidth = a.getDimension(R.styleable.BubbleLayout_bl_arrowWidth, BubbleLayout.convertDpToPixel(8.0f, context));
        this.mArrowHeight = a.getDimension(R.styleable.BubbleLayout_bl_arrowHeight, BubbleLayout.convertDpToPixel(8.0f, context));
        this.mCornersRadius = a.getDimension(R.styleable.BubbleLayout_bl_cornersRadius, 0.0f);
        this.mArrowPosition = a.getDimension(R.styleable.BubbleLayout_bl_arrowPosition, BubbleLayout.convertDpToPixel(12.0f, context));
        this.mBubbleColor = a.getColor(R.styleable.BubbleLayout_bl_bubbleColor, -1);
        this.mStrokeWidth = a.getDimension(R.styleable.BubbleLayout_bl_strokeWidth, DEFAULT_STROKE_WIDTH);
        this.mStrokeColor = a.getColor(R.styleable.BubbleLayout_bl_strokeColor, -7829368);
        int location = a.getInt(R.styleable.BubbleLayout_bl_arrowDirection, ArrowDirection.LEFT.getValue());
        this.mArrowDirection = ArrowDirection.fromInt(location);
        a.recycle();
        this.bubblePaddingLeft = this.getPaddingLeft();
        this.bubblePaddingRight = this.getPaddingRight();
        this.bubblePaddingTop = this.getPaddingTop();
        this.bubblePaddingBottom = this.getPaddingBottom();
        this.initPadding();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.initDrawable(0, this.getWidth(), 0, this.getHeight());
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mBubble != null) {
            this.mBubble.draw(canvas);
        }
        super.dispatchDraw(canvas);
    }

    public void setArrowPosition(float mArrowPosition) {
        this.mArrowPosition = mArrowPosition;
        this.requestLayout();
    }

    public void setArrowDirection(int direction) {
        this.mArrowDirection = ArrowDirection.fromInt(direction);
        this.initPadding();
    }

    public void setArrowSize(float width, float height) {
        this.mArrowWidth = width;
        this.mArrowHeight = height;
    }

    public void setCornersRadius(float cornersRadius) {
        this.mCornersRadius = cornersRadius;
    }

    public void setBubbleColor(int bubbleColor) {
        this.mBubbleColor = bubbleColor;
    }

    private void initDrawable(int left, int right, int top, int bottom) {
        if (right < left || bottom < top) {
            return;
        }
        RectF rectF = new RectF((float)left, (float)top, (float)right, (float)bottom);
        this.mBubble = new Bubble(rectF, this.mArrowWidth, this.mCornersRadius, this.mArrowHeight, this.mArrowPosition, this.mStrokeWidth, this.mStrokeColor, this.mBubbleColor, this.mArrowDirection);
    }

    private void initPadding() {
        int paddingLeft = this.bubblePaddingLeft;
        int paddingRight = this.bubblePaddingRight;
        int paddingTop = this.bubblePaddingTop;
        int paddingBottom = this.bubblePaddingBottom;
        switch (this.mArrowDirection) {
            case LEFT: {
                paddingLeft = (int)((float)paddingLeft + this.mArrowWidth);
                break;
            }
            case RIGHT: {
                paddingRight = (int)((float)paddingRight + this.mArrowWidth);
                break;
            }
            case TOP: {
                paddingTop = (int)((float)paddingTop + this.mArrowHeight);
                break;
            }
            case BOTTOM: {
                paddingBottom = (int)((float)paddingBottom + this.mArrowHeight);
                break;
            }
        }
        if (this.mStrokeWidth > 0.0f) {
            paddingLeft = (int)((float)paddingLeft + this.mStrokeWidth);
            paddingRight = (int)((float)paddingRight + this.mStrokeWidth);
            paddingTop = (int)((float)paddingTop + this.mStrokeWidth);
            paddingBottom = (int)((float)paddingBottom + this.mStrokeWidth);
        }
        this.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    static float convertDpToPixel(float dp, Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return dp * (float)(metrics.densityDpi / 160);
    }
}

