/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;

public abstract class ViewHolderAdapterCompat
extends BaseAdapter {
    public abstract int getCount();

    public abstract Object getItem(int var1);

    public long getItemId(int position) {
        return 0L;
    }

    public final View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null) {
            convertView = this.onCreateView(parent, position);
            holder = new ViewHolder(convertView, this.getItemViewType(position));
            convertView.setTag((Object)holder);
        }
        holder = (ViewHolder)convertView.getTag();
        this.onBindView(holder, position);
        return convertView;
    }

    public abstract View onCreateView(ViewGroup var1, int var2);

    public abstract void onBindView(ViewHolder var1, int var2);

    public class ViewHolder {
        private View mItemView;
        private SparseArray<View> mViewHolder = new SparseArray();
        private int mViewType;

        public View getItemView() {
            return this.mItemView;
        }

        public int getViewType() {
            return this.mViewType;
        }

        public ViewHolder(View convertView, int viewType) {
            this.mItemView = convertView;
            this.mViewType = viewType;
        }

        public <T extends View> T get(int id2) {
            View childView;
            if (this.mViewHolder == null) {
                this.mViewHolder = new SparseArray();
            }
            if ((childView = (View)this.mViewHolder.get(id2)) == null) {
                childView = this.mItemView.findViewById(id2);
                this.mViewHolder.put(id2, (Object)childView);
            }
            return (T)childView;
        }
    }
}

