/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.widget.ProgressBar;

public class TextProgressBar
extends ProgressBar {
    private String str = "";
    private Paint mPaint;
    Rect rect = new Rect();

    public TextProgressBar(Context context) {
        super(context);
        this.initPaint();
    }

    public TextProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initPaint();
    }

    public TextProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPaint();
    }

    @TargetApi(value=21)
    public TextProgressBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initPaint();
    }

    public void setText(String text) {
        this.str = text;
    }

    public void setTextColor(int color2) {
        this.mPaint.setColor(color2);
    }

    public void setTextSize(int size) {
        this.mPaint.setTextSize((float)size);
    }

    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.getTextBounds(this.str, 0, this.str.length(), this.rect);
        int x = this.getWidth() - this.rect.width() - 20;
        int y = this.getHeight() / 2 - this.rect.centerY();
        canvas.drawText(this.str, (float)x, (float)y, this.mPaint);
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
    }
}

