/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import com.yy.mobile.framework.R;

public class SquareButton
extends Button {
    private boolean isWidth = false;
    private boolean isHeight = false;
    private int maxSide;

    public SquareButton(Context context) {
        super(context);
    }

    public SquareButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.handleAttr(context, attributeSet);
    }

    public SquareButton(Context context, AttributeSet attributeSet, int defStyle) {
        super(context, attributeSet, defStyle);
        this.handleAttr(context, attributeSet);
    }

    private void handleAttr(Context context, AttributeSet attributeSet) {
        TypedArray array = context.obtainStyledAttributes(attributeSet, R.styleable.SquareButton);
        this.isWidth = array.getBoolean(R.styleable.SquareButton_squareForWidth, false);
        this.isHeight = array.getBoolean(R.styleable.SquareButton_squareForHeight, false);
        this.maxSide = array.getDimensionPixelSize(R.styleable.SquareButton_maxSide, 0);
        if (this.isHeight && this.isWidth) {
            throw new IllegalArgumentException("squareForWidth and SquareButton_squareForHeight cannot be true at the sme widget!");
        }
        array.recycle();
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.isHeight) {
            if (heightSize > this.maxSide && this.maxSide > 0) {
                heightSize = this.maxSide;
            }
            this.setMeasuredDimension(heightSize, heightSize);
        } else if (this.isWidth) {
            if (widthSize > this.maxSide && this.maxSide > 0) {
                widthSize = this.maxSide;
            }
            this.setMeasuredDimension(widthSize, widthSize);
        } else {
            this.setMeasuredDimension(widthSize, heightSize);
        }
    }
}

