/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.AnimationDrawable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.yy.mobile.framework.R;

public class ImTouchVoiceButton
extends RelativeLayout {
    public static final String TAG = "ImTouchVoiceButton";
    private ImageView mImage;
    private ImageView mWave;
    private Rect mImageRect = new Rect();
    private TouchVoiceListener mListener;
    private float mDownX;
    private float mDownY;
    private boolean mEverDown;
    private boolean mEverOutside;
    private boolean mEverInside;
    public Runnable runnable = new Runnable(){

        @Override
        public void run() {
            if (ImTouchVoiceButton.this.mListener != null) {
                ImTouchVoiceButton.this.mListener.onPressDown();
            }
            ImTouchVoiceButton.this.mInternalListener.onPressDown();
        }
    };
    private boolean shouldHandle = true;
    private long lastDownTime = 0L;
    private boolean forceUp = false;
    private TouchVoiceListener mInternalListener = new TouchVoiceListener(){

        @Override
        public void onPressDown() {
            ImTouchVoiceButton.this.mWave.setVisibility(0);
            if (ImTouchVoiceButton.this.mWave.getDrawable() instanceof AnimationDrawable) {
                ((AnimationDrawable)ImTouchVoiceButton.this.mWave.getDrawable()).start();
            }
        }

        @Override
        public void onLossen(boolean shouldSend) {
            if (ImTouchVoiceButton.this.mWave.getDrawable() instanceof AnimationDrawable) {
                ((AnimationDrawable)ImTouchVoiceButton.this.mWave.getDrawable()).stop();
            }
            ImTouchVoiceButton.this.mWave.setVisibility(8);
            ImTouchVoiceButton.this.mImage.setImageResource(R.drawable.touch_voice_btn_unpressed);
        }

        @Override
        public void onMoveOut() {
            ImTouchVoiceButton.this.mImage.setImageResource(R.drawable.touch_voice_btn_pressed);
        }

        @Override
        public void onMoveIn() {
            ImTouchVoiceButton.this.mImage.setImageResource(R.drawable.touch_voice_btn_unpressed);
        }
    };

    public ImTouchVoiceButton(Context context) {
        super(context);
        this.init();
    }

    public ImTouchVoiceButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ImTouchVoiceButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.widget_touch_voice, (ViewGroup)this, true);
        this.mImage = (ImageView)this.findViewById(R.id.voice_btn);
        this.mWave = (ImageView)this.findViewById(R.id.sound_wave);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
    }

    public void setListener(TouchVoiceListener listener) {
        this.mListener = listener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getActionMasked();
        if (this.forceUp) {
            if (action == 1 || action == 3) {
                this.forceUp = false;
            }
            return false;
        }
        float rawX = event.getRawX();
        float rawY = event.getRawY();
        if (this.mImageRect.isEmpty()) {
            this.mImage.getGlobalVisibleRect(this.mImageRect);
        }
        switch (action) {
            case 0: {
                this.mDownX = rawX;
                this.mDownY = rawY;
                long currentTime = SystemClock.elapsedRealtime();
                if (this.mImageRect.contains((int)rawX, (int)rawY) && currentTime - this.lastDownTime > 500L) {
                    this.lastDownTime = currentTime;
                    if (this.mListener != null) {
                        this.mListener.onPressDown();
                    }
                    this.mInternalListener.onPressDown();
                    this.mEverDown = true;
                    this.mEverInside = true;
                    break;
                }
                if (currentTime - this.lastDownTime <= 500L) break;
                this.lastDownTime = currentTime;
                break;
            }
            case 2: {
                if (!this.mEverOutside && this.mEverDown && !this.mImageRect.contains((int)rawX, (int)rawY)) {
                    this.mEverOutside = true;
                    this.mEverInside = false;
                    if (this.mListener != null) {
                        this.mListener.onMoveOut();
                    }
                    this.mInternalListener.onMoveOut();
                    break;
                }
                if (!this.mImageRect.contains((int)rawX, (int)rawY) || !this.mEverOutside || this.mEverInside) break;
                this.mEverOutside = false;
                this.mEverInside = true;
                if (this.mListener != null) {
                    this.mListener.onMoveIn();
                }
                this.mInternalListener.onMoveIn();
                break;
            }
            case 1: {
                this.mDownX = 0.0f;
                this.mDownY = 0.0f;
                this.lastDownTime = SystemClock.elapsedRealtime();
                if (this.mEverDown) {
                    if (this.mListener != null) {
                        this.mListener.onLossen(this.mEverInside);
                    }
                    this.mInternalListener.onLossen(this.mEverInside);
                }
                this.mEverDown = false;
                this.mEverOutside = false;
                this.mEverInside = false;
                break;
            }
            case 3: {
                this.mDownX = 0.0f;
                this.mDownY = 0.0f;
                this.mEverDown = false;
                this.mEverOutside = false;
                this.mEverInside = false;
                this.lastDownTime = SystemClock.elapsedRealtime();
                break;
            }
        }
        return true;
    }

    public void foreceUp() {
        this.forceUp = true;
        this.mDownX = 0.0f;
        this.mDownY = 0.0f;
        this.mEverDown = false;
        this.mEverOutside = false;
        this.mEverInside = false;
        this.mInternalListener.onLossen(true);
    }

    public void moveOut() {
        this.mEverDown = false;
        this.mInternalListener.onLossen(false);
    }

    public static interface TouchVoiceListener {
        public void onPressDown();

        public void onLossen(boolean var1);

        public void onMoveOut();

        public void onMoveIn();
    }
}

