/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import java.lang.ref.WeakReference;

public class DrawableTextView
extends TextView {
    private WeakReference<DrawableLeftListener> mLeftListener;
    private WeakReference<DrawableRightListener> mRightListener;
    static final int DRAWABLE_LEFT = 0;
    static final int DRAWABLE_TOP = 1;
    static final int DRAWABLE_RIGHT = 2;
    static final int DRAWABLE_BOTTOM = 3;

    public DrawableTextView(Context context) {
        super(context);
    }

    public DrawableTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public DrawableTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setDrawableLeftListener(DrawableLeftListener listener) {
        this.mLeftListener = listener == null ? null : new WeakReference<DrawableLeftListener>(listener);
    }

    public void setDrawableRightListener(DrawableRightListener listener) {
        this.mRightListener = listener == null ? null : new WeakReference<DrawableRightListener>(listener);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 1: {
                Drawable drawableLift;
                Drawable drawableRight;
                if (this.mRightListener != null && this.mRightListener.get() != null && (drawableRight = this.getCompoundDrawables()[2]) != null && event.getRawX() >= (float)(this.getRight() - drawableRight.getBounds().width())) {
                    ((DrawableRightListener)this.mRightListener.get()).onDrawableRightClick((View)this);
                    return true;
                }
                if (this.mLeftListener == null || this.mLeftListener.get() == null || (drawableLift = this.getCompoundDrawables()[0]) == null || !(event.getRawX() >= (float)(this.getLeft() + drawableLift.getBounds().width()))) break;
                ((DrawableLeftListener)this.mLeftListener.get()).onDrawableLeftClick((View)this);
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    public static interface DrawableLeftListener {
        public void onDrawableLeftClick(View var1);
    }

    public static interface DrawableRightListener {
        public void onDrawableRightClick(View var1);
    }
}

