/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.stuckminor.loopermintor;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.yy.mobile.stuckminor.base.IANRListener;
import com.yy.mobile.stuckminor.loopermintor.MsgExcuteListener;
import java.util.Map;

class LooperANRMonitor
implements MsgExcuteListener {
    private long mTimeOutTime;
    private HandlerThread mAnrHandlerThread;
    private Handler mAnrHandler;
    private volatile boolean mMsgFinished = false;
    private Context mContext;
    private IANRListener mANRLis;
    private Handler mHandler = new Handler();
    private final Thread mThread;
    private final Thread mMainThread;
    private Runnable mAnrRunnable = new Runnable(){

        @Override
        public void run() {
            LooperANRMonitor.this.generateStackTraces();
        }
    };

    public void setANRListener(IANRListener anrLis) {
        this.mANRLis = anrLis;
    }

    public LooperANRMonitor(Context context, long timeOutTime, Thread thread) {
        this.mContext = context;
        this.mTimeOutTime = timeOutTime;
        this.mThread = thread;
        this.mMainThread = Looper.getMainLooper().getThread();
        this.mAnrHandlerThread = new HandlerThread("ANR HANDLER THREAD", 10);
        this.mAnrHandlerThread.start();
        this.mAnrHandler = new Handler(this.mAnrHandlerThread.getLooper());
    }

    @Override
    public void start(String msg, long startRealTime, long startCPUTime) {
        this.mMsgFinished = false;
        this.mAnrHandler.removeCallbacks(this.mAnrRunnable);
        this.mAnrHandler.postDelayed(this.mAnrRunnable, this.mTimeOutTime);
    }

    @Override
    public void end(String msg, long startRealTime, long startCPUTime, long consumeRealTime, long consumeCPUTime) {
        this.mMsgFinished = true;
        this.mAnrHandler.removeCallbacks(this.mAnrRunnable);
    }

    private boolean dumpStackTraces(Thread thread, StackTraceElement[] ste, StringBuilder buffer) {
        buffer.append(thread.getName() + " " + thread.getPriority() + " " + (Object)((Object)thread.getState()) + "\n");
        int index = 0;
        for (StackTraceElement e : ste) {
            String line = e.toString();
            if (this.mThread == this.mMainThread && index == 0 && "android.os.MessageQueue.nativePollOnce(Native Method)".equals(line)) {
                return false;
            }
            buffer.append("  at " + line + "\n");
            ++index;
        }
        buffer.append("\n");
        return true;
    }

    private void generateStackTraces() {
        final StringBuilder buffer = new StringBuilder();
        if (this.mThread != null) {
            StackTraceElement[] ste = this.mThread.getStackTrace();
            if (!this.dumpStackTraces(this.mThread, ste, buffer)) {
                return;
            }
        } else {
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                if (this.dumpStackTraces(entry.getKey(), entry.getValue(), buffer)) continue;
                return;
            }
        }
        if (!this.mMsgFinished) {
            buffer.insert(0, "FreeMem:" + this.getFreeMemory() + "\n");
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (LooperANRMonitor.this.mANRLis != null && buffer.length() > 0) {
                        LooperANRMonitor.this.mANRLis.anrStack(buffer.toString());
                    }
                }
            });
        }
    }

    private long getFreeMemory() {
        if (this.mContext == null) {
            return 0L;
        }
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
        activityManager.getMemoryInfo(mi);
        long availableMegs = mi.availMem / 0x100000L;
        return availableMegs;
    }

    void stop() {
        this.mMsgFinished = true;
        this.mAnrHandler.removeCallbacks(this.mAnrRunnable);
    }
}

