/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext;

import android.content.Context;
import android.text.Spannable;
import android.text.TextUtils;
import com.yy.mobile.richtext.BaseRichTextFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VipEmoticonFilter
extends BaseRichTextFilter {
    public static final String PREFIX = "yy://yyvip-";
    public static final String EMOTICON_BEGIN = "[=";
    public static final String EMOTICON_END = "]";
    public static final String VIPEMOTICON_DEFAULT = "[\u4f1a\u5458\u8868\u60c5]";
    protected static final String REG_CONTENT = ".*?";
    public static final Pattern EmoticonPattern = VipEmoticonFilter.getEmoticonPattern();

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth) {
        this.parseSpannable(context, spannable, maxWidth, null);
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth, Object tag) {
    }

    private static String convertTagToReg(String tag) {
        return tag.replace("[", "\\[").replace(EMOTICON_END, "\\]");
    }

    private static Pattern getEmoticonPattern() {
        StringBuilder reg = new StringBuilder(PREFIX);
        reg.append(VipEmoticonFilter.convertTagToReg(EMOTICON_BEGIN));
        reg.append(VipEmoticonFilter.convertTagToReg(REG_CONTENT));
        reg.append(VipEmoticonFilter.convertTagToReg(EMOTICON_END));
        return Pattern.compile(reg.toString());
    }

    public static boolean isEmojiMessage(String str) {
        return EmoticonPattern.matcher(str).find();
    }

    public static String replaceVipEmoticonWithGivenStr(String message, String givenStr) {
        if (!VipEmoticonFilter.isEmojiMessage(message)) {
            return message;
        }
        Matcher m = EmoticonPattern.matcher(message);
        String messageReplce = m.replaceAll(givenStr).trim();
        if (TextUtils.isEmpty((CharSequence)(messageReplce = messageReplce.replaceAll(VipEmoticonFilter.convertTagToReg(givenStr), "").trim()))) {
            messageReplce = givenStr;
        }
        return messageReplce;
    }
}

