/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext;

import android.content.Context;
import android.text.Spannable;
import android.text.TextUtils;
import com.yy.mobile.richtext.BaseRichTextFilter;
import com.yy.mobile.util.log.MLog;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChannelImageEmoticonFilter
extends BaseRichTextFilter {
    public static final String EMOTICON_BEGIN = "[Image]";
    public static final String EMOTICON_END = "[/Image]";
    public static final String CHANNELIMAGE_DEFAULT = "[\u56fe\u7247]";
    protected static final String REG_CONTENT = ".*?";
    public static final Pattern EmoticonPattern = ChannelImageEmoticonFilter.getEmoticonPattern();

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth) {
        this.parseSpannable(context, spannable, maxWidth, null);
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth, Object tag) {
    }

    private static String convertTagToReg(String tag) {
        return tag.replace("[", "\\[").replace("]", "\\]");
    }

    private static Pattern getEmoticonPattern() {
        StringBuilder reg = new StringBuilder();
        reg.append(ChannelImageEmoticonFilter.convertTagToReg(EMOTICON_BEGIN));
        reg.append(ChannelImageEmoticonFilter.convertTagToReg(REG_CONTENT));
        reg.append(ChannelImageEmoticonFilter.convertTagToReg(EMOTICON_END));
        return Pattern.compile(reg.toString());
    }

    public static boolean isEmojiMessage(String str) {
        return EmoticonPattern.matcher(str).find();
    }

    public static String replaceChannelImageEmoticonWithGivenStr(String message, String givenStr) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug("ChannelImageEmoticonFilter start ", " message = " + message, new Object[0]);
        }
        if (!ChannelImageEmoticonFilter.isEmojiMessage(message)) {
            return message;
        }
        Matcher m = EmoticonPattern.matcher(message);
        String messageReplce = m.replaceAll(givenStr).trim();
        if (TextUtils.isEmpty((CharSequence)(messageReplce = messageReplce.replaceAll(ChannelImageEmoticonFilter.convertTagToReg(givenStr), "").trim()))) {
            messageReplce = givenStr;
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug("ChannelImageEmoticonFilter end", " messageReplce = " + messageReplce, new Object[0]);
        }
        return messageReplce;
    }
}

