/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.richtext;

import android.content.Context;
import android.text.Spannable;
import android.text.style.CharacterStyle;
import android.view.View;
import com.yy.mobile.richtext.RichTextFilter;
import com.yy.mobile.util.FP;
import java.util.List;

public abstract class BaseRichTextFilter
implements RichTextFilter {
    protected OnSpanClickListener mOnSpanClickListener;
    private String currentContext;

    public void setSpanClickListener(OnSpanClickListener listener) {
        this.setSpanClickListener(listener, "");
    }

    public void setSpanClickListener(OnSpanClickListener listener, String currentContext) {
        this.mOnSpanClickListener = listener;
        this.currentContext = currentContext;
    }

    public void clearSpanClickListener(String currentContext) {
        if (FP.eq(this.currentContext, currentContext)) {
            this.mOnSpanClickListener = null;
        }
    }

    protected void setSpannable(List<Object> list, Spannable spannable, int start, int end, int flags) {
        if (spannable == null) {
            return;
        }
        if (this.removeOrIgnoreSpan(spannable, start, end)) {
            return;
        }
        for (Object what : list) {
            if (start > end || start > spannable.length()) continue;
            if (end > spannable.length()) {
                end = spannable.length();
            }
            spannable.setSpan(what, start, end, flags);
        }
    }

    protected void setSpannable(Object what, Spannable spannable, int start, int end, int flags) {
        if (spannable == null) {
            return;
        }
        if (this.removeOrIgnoreSpan(spannable, start, end)) {
            return;
        }
        if (start <= end && start <= spannable.length()) {
            if (end > spannable.length()) {
                end = spannable.length();
            }
            spannable.setSpan(what, start, end, flags);
        }
    }

    protected boolean removeOrIgnoreSpan(Spannable spannable, int start, int end) {
        CharacterStyle[] spans;
        for (CharacterStyle span : spans = (CharacterStyle[])spannable.getSpans(0, spannable.length(), CharacterStyle.class)) {
            int spanStart = spannable.getSpanStart((Object)span);
            int spanEnd = spannable.getSpanEnd((Object)span);
            if (start <= spanStart && end > spanStart) {
                spannable.removeSpan((Object)span);
                return false;
            }
            if ((start <= spanStart || start >= spanEnd) && (end <= spanStart || end >= spanEnd)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth) {
        this.parseSpannable(context, spannable, maxWidth, null);
    }

    @Override
    public void parseSpannable(Context context, Spannable spannable, int maxWidth, int normal) {
    }

    @Override
    public abstract void parseSpannable(Context var1, Spannable var2, int var3, Object var4);

    public static interface OnSpanClickListener {
        public void onClick(View var1, Object var2);
    }
}

